/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.hash;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.HttpDownloader;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public final class DownloadAssetCommand
extends Command {
    public DownloadAssetCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[version] [dir]";
    }

    public String getUsageDescription() {
        return "Download asset dir";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 2);
        ClientProfile.Version version = ClientProfile.Version.byName((String)args[0]);
        String dirName = IOHelper.verifyFileName((String)args[1]);
        Path assetDir = this.server.updatesDir.resolve(dirName);
        LogHelper.subInfo((String)"Creating asset dir: '%s'", (Object[])new Object[]{dirName});
        Files.createDirectory(assetDir, new FileAttribute[0]);
        LogHelper.subInfo((String)"Downloading asset, it may take some time");
        HttpDownloader.downloadZip((URL)this.server.mirrorManager.getDefaultMirror().getAssetsURL(version.name), (Path)assetDir);
        this.server.syncUpdatesDir(Collections.singleton(dirName));
        LogHelper.subInfo((String)"Asset successfully downloaded: '%s'", (Object[])new Object[]{dirName});
    }
}

