/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.service;

import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.NeedGarbageCollection;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.components.Component;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class ComponentCommand
extends Command {
    public ComponentCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[action] [component name] [more args]";
    }

    public String getUsageDescription() {
        return "component manager";
    }

    public void printHelp() {
        LogHelper.info((String)"Print help for component:");
        LogHelper.subInfo((String)"component unload [componentName]");
        LogHelper.subInfo((String)"component load [componentName] [filename]");
        LogHelper.subInfo((String)"component gc [componentName]");
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        String componentName = null;
        if (args.length > 1) {
            componentName = args[1];
        }
        switch (args[0]) {
            case "unload": {
                if (componentName == null) {
                    throw new IllegalArgumentException("Must set componentName");
                }
                Component component = this.server.config.components.get(componentName);
                if (component == null) {
                    LogHelper.error((String)"Component %s not found", (Object[])new Object[]{componentName});
                    return;
                }
                if (component instanceof AutoCloseable) {
                    ((AutoCloseable)((Object)component)).close();
                    break;
                }
                LogHelper.error((String)"Component %s unload not supported", (Object[])new Object[]{componentName});
                return;
            }
            case "gc": {
                if (componentName == null) {
                    throw new IllegalArgumentException("Must set componentName");
                }
                Component component = this.server.config.components.get(componentName);
                if (component == null) {
                    LogHelper.error((String)"Component %s not found", (Object[])new Object[]{componentName});
                    return;
                }
                if (component instanceof NeedGarbageCollection) {
                    ((NeedGarbageCollection)component).garbageCollection();
                    break;
                }
                LogHelper.error((String)"Component %s gc not supported", (Object[])new Object[]{componentName});
                return;
            }
            case "load": {
                if (componentName == null) {
                    throw new IllegalArgumentException("Must set componentName");
                }
                if (args.length <= 2) {
                    throw new IllegalArgumentException("Must set file");
                }
                String fileName = args[2];
                try (BufferedReader reader = IOHelper.newReader((Path)Paths.get(fileName, new String[0]));){
                    Component component = (Component)Launcher.gsonManager.configGson.fromJson((Reader)reader, Component.class);
                    component.preInit(this.server);
                    component.init(this.server);
                    component.postInit(this.server);
                    LogHelper.info((String)"Component %s(%s) loaded", (Object[])new Object[]{componentName, component.getClass().getName()});
                }
            }
            case "help": {
                this.printHelp();
            }
            default: {
                this.printHelp();
            }
        }
    }
}

