/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.manangers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import pro.gravit.utils.helper.IOHelper;

public class MirrorManager {
    protected ArrayList<Mirror> list = new ArrayList();
    private Mirror defaultMirror;

    public void addMirror(String mirror) {
        Mirror m = new Mirror(mirror);
        m.enabled = true;
        if (this.defaultMirror == null) {
            this.defaultMirror = m;
        }
    }

    public void addMirror(String mirror, boolean enabled) throws MalformedURLException {
        Mirror m = new Mirror(mirror);
        m.url = new URL(mirror);
        m.enabled = enabled;
        if (this.defaultMirror == null && enabled) {
            this.defaultMirror = m;
        }
    }

    public Mirror getDefaultMirror() {
        return this.defaultMirror;
    }

    public void setDefaultMirror(Mirror m) {
        this.defaultMirror = m;
    }

    public void disableMirror(int index) {
        this.list.get((int)index).enabled = false;
    }

    public void enableMirror(int index) {
        this.list.get((int)index).enabled = true;
    }

    public int size() {
        return this.list.size();
    }

    public class Mirror {
        URL url;
        String assetsURLMask;
        String clientsURLMask;
        boolean enabled;

        Mirror(String url) {
            this.assetsURLMask = url.concat("assets/%s.zip");
            this.clientsURLMask = url.concat("clients/%s.zip");
        }

        private URL formatArg(String mask, String arg) throws MalformedURLException {
            return new URL(String.format(mask, IOHelper.urlEncode((String)arg)));
        }

        public URL getAssetsURL(String assets) throws MalformedURLException {
            return this.formatArg(this.assetsURLMask, assets);
        }

        public URL getClientsURL(String client) throws MalformedURLException {
            return this.formatArg(this.clientsURLMask, client);
        }
    }
}

