/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.manangers.hook;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pro.gravit.launcher.AutogenConfig;
import pro.gravit.launchserver.binary.BuildContext;
import pro.gravit.launchserver.binary.LauncherConfigurator;
import pro.gravit.launchserver.binary.tasks.MainBuildTask;

public class BuildHookManager {
    private boolean BUILDRUNTIME = true;
    private final Set<BuildHook> HOOKS = new HashSet<BuildHook>(4);
    private final Set<Transformer> CLASS_TRANSFORMER;
    private final Set<String> CLASS_BLACKLIST = new HashSet<String>(4);
    private final Set<String> MODULE_CLASS = new HashSet<String>(4);
    private final Map<String, byte[]> INCLUDE_CLASS = new HashMap<String, byte[]>(4);

    public BuildHookManager() {
        this.CLASS_TRANSFORMER = new HashSet<Transformer>(4);
        this.autoRegisterIgnoredClass(AutogenConfig.class.getName());
        this.registerIgnoredClass("META-INF/DEPENDENCIES");
        this.registerIgnoredClass("META-INF/LICENSE");
        this.registerIgnoredClass("META-INF/NOTICE");
    }

    public void autoRegisterIgnoredClass(String clazz) {
        this.CLASS_BLACKLIST.add(clazz.replace('.', '/').concat(".class"));
    }

    public boolean buildRuntime() {
        return this.BUILDRUNTIME;
    }

    public byte[] classTransform(byte[] clazz, String classname, MainBuildTask reader) {
        byte[] result = clazz;
        for (Transformer transformer : this.CLASS_TRANSFORMER) {
            result = transformer.transform(result, classname, reader);
        }
        return result;
    }

    public void registerIncludeClass(String classname, byte[] classdata) {
        this.INCLUDE_CLASS.put(classname, classdata);
    }

    public Map<String, byte[]> getIncludeClass() {
        return this.INCLUDE_CLASS;
    }

    public boolean isContainsBlacklist(String clazz) {
        for (String classB : this.CLASS_BLACKLIST) {
            if (!clazz.startsWith(classB)) continue;
            return true;
        }
        return false;
    }

    public void hook(BuildContext context) {
        for (BuildHook hook : this.HOOKS) {
            hook.build(context);
        }
    }

    public void registerAllClientModuleClass(LauncherConfigurator cfg) {
        for (String clazz : this.MODULE_CLASS) {
            cfg.addModuleClass(clazz);
        }
    }

    public void registerClassTransformer(Transformer transformer) {
        this.CLASS_TRANSFORMER.add(transformer);
    }

    public void registerClientModuleClass(String clazz) {
        this.MODULE_CLASS.add(clazz);
    }

    public void unregisterClientModuleClass(String clazz) {
        this.MODULE_CLASS.remove(clazz);
    }

    public void clearClientModuleClassList() {
        this.MODULE_CLASS.clear();
    }

    public void registerIgnoredClass(String clazz) {
        this.CLASS_BLACKLIST.add(clazz);
    }

    public void registerHook(BuildHook hook) {
        this.HOOKS.add(hook);
    }

    public void setBuildRuntime(boolean runtime) {
        this.BUILDRUNTIME = runtime;
    }

    @FunctionalInterface
    public static interface Transformer {
        public byte[] transform(byte[] var1, String var2, MainBuildTask var3);
    }

    @FunctionalInterface
    public static interface BuildHook {
        public void build(BuildContext var1);
    }
}

