/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.asm;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import pro.gravit.utils.helper.IOHelper;

public class ClassMetadataReader
implements Closeable {
    private final List<JarFile> cp;

    public ClassMetadataReader(List<JarFile> cp) {
        this.cp = cp;
    }

    public List<JarFile> getCp() {
        return this.cp;
    }

    public ClassMetadataReader() {
        this.cp = new ArrayList<JarFile>();
    }

    public void acceptVisitor(byte[] classData, ClassVisitor visitor) {
        new ClassReader(classData).accept(visitor, 0);
    }

    public void acceptVisitor(String className, ClassVisitor visitor) throws IOException {
        this.acceptVisitor(this.getClassData(className), visitor);
    }

    public void acceptVisitor(byte[] classData, ClassVisitor visitor, int flags) {
        new ClassReader(classData).accept(visitor, flags);
    }

    public void acceptVisitor(String className, ClassVisitor visitor, int flags) throws IOException {
        this.acceptVisitor(this.getClassData(className), visitor, flags);
    }

    public byte[] getClassData(String className) throws IOException {
        for (JarFile f : this.cp) {
            byte[] bytes;
            if (f.getEntry(className + ".class") == null) continue;
            try (InputStream in = f.getInputStream(f.getEntry(className + ".class"));){
                bytes = IOHelper.read((InputStream)in);
            }
            return bytes;
        }
        return IOHelper.read((URL)IOHelper.getResourceURL((String)(className + ".class")));
    }

    public String getSuperClass(String type) {
        if (type.equals("java/lang/Object")) {
            return null;
        }
        try {
            return this.getSuperClassASM(type);
        }
        catch (Exception e) {
            return "java/lang/Object";
        }
    }

    protected String getSuperClassASM(String type) throws IOException {
        CheckSuperClassVisitor cv = new CheckSuperClassVisitor();
        this.acceptVisitor(type, (ClassVisitor)cv);
        return cv.superClassName;
    }

    public ArrayList<String> getSuperClasses(String type) {
        ArrayList<String> superclasses = new ArrayList<String>(1);
        superclasses.add(type);
        while ((type = this.getSuperClass(type)) != null) {
            superclasses.add(type);
        }
        Collections.reverse(superclasses);
        return superclasses;
    }

    @Override
    public void close() {
        this.cp.forEach(IOHelper::close);
        this.cp.clear();
    }

    private static class CheckSuperClassVisitor
    extends ClassVisitor {
        String superClassName;

        public CheckSuperClassVisitor() {
            super(458752);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.superClassName = superName;
        }
    }
}

