/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.IntPredicate;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class PostgreSQLSourceConfig
implements AutoCloseable {
    public static final int TIMEOUT = VerifyHelper.verifyInt((int)Integer.parseUnsignedInt(System.getProperty("launcher.postgresql.idleTimeout", Integer.toString(5000))), (IntPredicate)VerifyHelper.POSITIVE, (String)"launcher.postgresql.idleTimeout can't be <= 5000");
    private static final int MAX_POOL_SIZE = VerifyHelper.verifyInt((int)Integer.parseUnsignedInt(System.getProperty("launcher.postgresql.maxPoolSize", Integer.toString(3))), (IntPredicate)VerifyHelper.POSITIVE, (String)"launcher.postgresql.maxPoolSize can't be <= 0");
    private String poolName;
    private String address;
    private int port;
    private String username;
    private String password;
    private String database;
    private DataSource source;
    private boolean hikari;

    @Override
    public synchronized void close() {
        if (this.hikari) {
            ((HikariDataSource)this.source).close();
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.source == null) {
            PGSimpleDataSource postgresqlSource = new PGSimpleDataSource();
            postgresqlSource.setServerName(this.address);
            postgresqlSource.setPortNumber(this.port);
            postgresqlSource.setUser(this.username);
            postgresqlSource.setPassword(this.password);
            postgresqlSource.setDatabaseName(this.database);
            this.source = postgresqlSource;
            try {
                Class.forName("com.zaxxer.hikari.HikariDataSource");
                this.hikari = true;
                HikariDataSource hikariSource = new HikariDataSource();
                hikariSource.setDataSource(this.source);
                hikariSource.setPoolName(this.poolName);
                hikariSource.setMinimumIdle(0);
                hikariSource.setMaximumPoolSize(MAX_POOL_SIZE);
                hikariSource.setIdleTimeout((long)TIMEOUT * 1000L);
                this.source = hikariSource;
                LogHelper.info((String)"HikariCP pooling enabled for '%s'", (Object[])new Object[]{this.poolName});
            }
            catch (ClassNotFoundException ignored) {
                LogHelper.warning((String)"HikariCP isn't in classpath for '%s'", (Object[])new Object[]{this.poolName});
            }
        }
        return this.source.getConnection();
    }
}

