/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.handler;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import pro.gravit.launchserver.auth.handler.AuthHandler;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.utils.helper.VerifyHelper;

public final class NullAuthHandler
extends AuthHandler {
    private volatile AuthHandler handler;

    @Override
    public UUID auth(AuthProviderResult authResult2) throws IOException {
        return this.getHandler().auth(authResult2);
    }

    @Override
    public UUID checkServer(String username, String serverID) throws IOException {
        return this.getHandler().checkServer(username, serverID);
    }

    @Override
    public void close() throws IOException {
        AuthHandler handler = this.handler;
        if (handler != null) {
            handler.close();
        }
    }

    private AuthHandler getHandler() {
        return (AuthHandler)VerifyHelper.verify((Object)this.handler, Objects::nonNull, (String)"Backend auth handler wasn't set");
    }

    @Override
    public boolean joinServer(String username, String accessToken, String serverID) throws IOException {
        return this.getHandler().joinServer(username, accessToken, serverID);
    }

    public void setBackend(AuthHandler handler) {
        this.handler = handler;
    }

    @Override
    public UUID usernameToUUID(String username) throws IOException {
        return this.getHandler().usernameToUUID(username);
    }

    @Override
    public String uuidToUsername(UUID uuid) throws IOException {
        return this.getHandler().uuidToUsername(uuid);
    }
}

