/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.handler;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.postgresql.util.PGobject;
import pro.gravit.launchserver.auth.PostgreSQLSourceConfig;
import pro.gravit.launchserver.auth.handler.CachedAuthHandler;

public final class PostgreSQLAuthHandler
extends CachedAuthHandler {
    private PostgreSQLSourceConfig postgreSQLHolder;
    private String uuidColumn;
    private String usernameColumn;
    private String accessTokenColumn;
    private String serverIDColumn;
    private String queryByUUIDSQL;
    private String queryByUsernameSQL;
    private String updateAuthSQL;
    private String updateServerIDSQL;

    @Override
    public void close() {
        this.postgreSQLHolder.close();
    }

    private CachedAuthHandler.Entry constructEntry(ResultSet set) throws SQLException {
        return set.next() ? new CachedAuthHandler.Entry(UUID.fromString(set.getString(this.uuidColumn)), set.getString(this.usernameColumn), set.getString(this.accessTokenColumn), set.getString(this.serverIDColumn)) : null;
    }

    @Override
    protected CachedAuthHandler.Entry fetchEntry(String username) throws IOException {
        return this.query(this.queryByUsernameSQL, username);
    }

    @Override
    protected CachedAuthHandler.Entry fetchEntry(UUID uuid) throws IOException {
        return this.query(this.queryByUUIDSQL, uuid);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean updateAuth(UUID uuid, String username, String accessToken) throws IOException {
        try (Connection c = this.postgreSQLHolder.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement s = c.prepareStatement(this.updateAuthSQL);
                try {
                    s.setString(1, username);
                    s.setString(2, accessToken);
                    PGobject uuidObject = new PGobject();
                    uuidObject.setType("uuid");
                    uuidObject.setValue(uuid.toString());
                    s.setObject(3, uuidObject);
                    s.setQueryTimeout(PostgreSQLSourceConfig.TIMEOUT);
                    boolean bl2 = bl = s.executeUpdate() > 0;
                    if (s == null) break block14;
                }
                catch (Throwable throwable) {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                s.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean updateServerID(UUID uuid, String serverID) throws IOException {
        try (Connection c = this.postgreSQLHolder.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement s = c.prepareStatement(this.updateServerIDSQL);
                try {
                    s.setString(1, serverID);
                    PGobject uuidObject = new PGobject();
                    uuidObject.setType("uuid");
                    uuidObject.setValue(uuid.toString());
                    s.setObject(2, uuidObject);
                    s.setQueryTimeout(PostgreSQLSourceConfig.TIMEOUT);
                    boolean bl2 = bl = s.executeUpdate() > 0;
                    if (s == null) break block14;
                }
                catch (Throwable throwable) {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                s.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private CachedAuthHandler.Entry query(String sql, String value) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private CachedAuthHandler.Entry query(String sql, UUID value) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

