/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.hwid;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pro.gravit.launcher.hwid.HWID;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.hwid.AcceptHWIDHandler;
import pro.gravit.launchserver.auth.hwid.HWIDException;
import pro.gravit.launchserver.auth.hwid.JsonFileHWIDHandler;
import pro.gravit.launchserver.auth.hwid.JsonHWIDHandler;
import pro.gravit.launchserver.auth.hwid.MemoryHWIDHandler;
import pro.gravit.launchserver.auth.hwid.MysqlHWIDHandler;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.LogHelper;

public abstract class HWIDHandler
implements AutoCloseable,
Reconfigurable {
    public static final ProviderMap<HWIDHandler> providers = new ProviderMap("HWIDHandler");
    private static boolean registredHandl = false;

    public static void registerHandlers() {
        if (!registredHandl) {
            providers.register("accept", AcceptHWIDHandler.class);
            providers.register("mysql", MysqlHWIDHandler.class);
            providers.register("json", JsonHWIDHandler.class);
            providers.register("jsonfile", JsonFileHWIDHandler.class);
            providers.register("memory", MemoryHWIDHandler.class);
            registredHandl = true;
        }
    }

    @Override
    public Map<String, Command> getCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("ban", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                List<HWID> target = HWIDHandler.this.getHwid(args[0]);
                HWIDHandler.this.ban(target);
            }
        });
        commands.put("unban", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                List<HWID> target = HWIDHandler.this.getHwid(args[0]);
                HWIDHandler.this.unban(target);
            }
        });
        commands.put("gethwid", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                List<HWID> target = HWIDHandler.this.getHwid(args[0]);
                for (HWID hwid : target) {
                    if (hwid == null) {
                        LogHelper.error((String)"[%s] HWID: null", (Object[])new Object[]{args[0]});
                        continue;
                    }
                    LogHelper.info((String)"[%s] HWID: %s", (Object[])new Object[]{args[0], hwid.toString()});
                }
            }
        });
        return commands;
    }

    public abstract void ban(List<HWID> var1) throws HWIDException;

    public void check(HWID hwid, String username) throws HWIDException {
        if (hwid.isNull()) {
            return;
        }
        this.check0(hwid, username);
    }

    public abstract void check0(HWID var1, String var2) throws HWIDException;

    @Override
    public abstract void close() throws Exception;

    public abstract void init();

    public abstract List<HWID> getHwid(String var1) throws HWIDException;

    public abstract void unban(List<HWID> var1) throws HWIDException;
}

