/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.provider.AuthProviderResult;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public final class RejectAuthProvider
extends AuthProvider
implements Reconfigurable {
    private String message;
    private ArrayList<String> whitelist;

    public RejectAuthProvider() {
    }

    public RejectAuthProvider(String message) {
        this.message = message;
    }

    @Override
    public AuthProviderResult auth(String login, AuthRequest.AuthPasswordInterface password, String ip) throws AuthException {
        if (this.whitelist != null) {
            for (String username : this.whitelist) {
                if (!login.equals(username)) continue;
                return new AuthProviderResult(login, SecurityHelper.randomStringToken(), ClientPermissions.DEFAULT);
            }
        }
        return RejectAuthProvider.authError(this.message);
    }

    @Override
    public void close() {
    }

    @Override
    public Map<String, Command> getCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("message", (Command)new SubCommand(){

            public void invoke(String ... args) {
                RejectAuthProvider.this.message = args[0];
                LogHelper.info((String)"New reject message: %s", (Object[])new Object[]{RejectAuthProvider.this.message});
            }
        });
        return commands;
    }
}

