/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.StreamObject;
import pro.gravit.launchserver.binary.tasks.MainBuildTask;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class BuildContext {
    public final ZipOutputStream output;
    public final List<JarFile> readerClassPath;
    public final MainBuildTask task;
    public final HashSet<String> fileList;
    public final HashSet<String> clientModules;

    public BuildContext(ZipOutputStream output, List<JarFile> readerClassPath, MainBuildTask task) {
        this.output = output;
        this.readerClassPath = readerClassPath;
        this.task = task;
        this.fileList = new HashSet(1024);
        this.clientModules = new HashSet();
    }

    public void pushFile(String filename, InputStream inputStream) throws IOException {
        ZipEntry zip = IOHelper.newZipEntry((String)filename);
        this.output.putNextEntry(zip);
        IOHelper.transfer((InputStream)inputStream, (OutputStream)this.output);
        this.output.closeEntry();
        this.fileList.add(filename);
    }

    public void pushFile(String filename, StreamObject object) throws IOException {
        ZipEntry zip = IOHelper.newZipEntry((String)filename);
        this.output.putNextEntry(zip);
        object.write(new HOutput((OutputStream)this.output));
        this.output.closeEntry();
        this.fileList.add(filename);
    }

    public void pushFile(String filename, Object object, Type type) throws IOException {
        String bytes = Launcher.gsonManager.gson.toJson(object, type);
        this.pushBytes(filename, bytes.getBytes(IOHelper.UNICODE_CHARSET));
    }

    public void pushDir(Path dir, String targetDir, Map<String, byte[]> hashMap, boolean hidden) throws IOException {
        IOHelper.walk((Path)dir, (FileVisitor)new RuntimeDirVisitor(this.output, hashMap, dir, targetDir), (boolean)hidden);
    }

    public void pushBytes(String filename, byte[] bytes) throws IOException {
        ZipEntry zip = IOHelper.newZipEntry((String)filename);
        this.output.putNextEntry(zip);
        this.output.write(bytes);
        this.output.closeEntry();
        this.fileList.add(filename);
    }

    @Deprecated
    public void pushJarFile(ZipInputStream input) throws IOException {
        ZipEntry e = input.getNextEntry();
        while (e != null) {
            if (this.fileList.contains(e.getName())) {
                e = input.getNextEntry();
                continue;
            }
            this.output.putNextEntry(IOHelper.newZipEntry((ZipEntry)e));
            IOHelper.transfer((InputStream)input, (OutputStream)this.output);
            this.fileList.add(e.getName());
            e = input.getNextEntry();
        }
    }

    @Deprecated
    public void pushJarFile(ZipInputStream input, Set<String> blacklist) throws IOException {
        ZipEntry e = input.getNextEntry();
        while (e != null) {
            if (this.fileList.contains(e.getName()) || blacklist.contains(e.getName())) {
                e = input.getNextEntry();
                continue;
            }
            this.output.putNextEntry(IOHelper.newZipEntry((ZipEntry)e));
            IOHelper.transfer((InputStream)input, (OutputStream)this.output);
            this.fileList.add(e.getName());
            e = input.getNextEntry();
        }
    }

    public void pushJarFile(Path jarfile, Predicate<ZipEntry> filter, Predicate<String> needTransform) throws IOException {
        this.pushJarFile(jarfile.toUri().toURL(), filter, needTransform);
    }

    public void pushJarFile(URL jarfile, Predicate<ZipEntry> filter, Predicate<String> needTransform) throws IOException {
        try (ZipInputStream input = new ZipInputStream(IOHelper.newInput((URL)jarfile));){
            ZipEntry e = input.getNextEntry();
            while (e != null) {
                String filename = e.getName();
                if (e.isDirectory() || this.fileList.contains(filename) || filter.test(e)) {
                    e = input.getNextEntry();
                    continue;
                }
                try {
                    this.output.putNextEntry(IOHelper.newZipEntry((ZipEntry)e));
                }
                catch (ZipException ex) {
                    LogHelper.warning((String)"Write %s failed: %s", (Object[])new Object[]{filename, ex.getMessage() == null ? "null" : ex.getMessage()});
                    e = input.getNextEntry();
                    continue;
                }
                if (filename.endsWith(".class")) {
                    String classname = filename.replace('/', '.').substring(0, filename.length() - ".class".length());
                    if (!needTransform.test(classname)) {
                        IOHelper.transfer((InputStream)input, (OutputStream)this.output);
                    } else {
                        byte[] bytes = IOHelper.read((InputStream)input);
                        bytes = this.task.transformClass(bytes, classname, this);
                        this.output.write(bytes);
                    }
                } else {
                    IOHelper.transfer((InputStream)input, (OutputStream)this.output);
                }
                this.fileList.add(filename);
                e = input.getNextEntry();
            }
        }
    }

    private static final class RuntimeDirVisitor
    extends SimpleFileVisitor<Path> {
        private final ZipOutputStream output;
        private final Map<String, byte[]> hashs;
        private final Path sourceDir;
        private final String targetDir;

        private RuntimeDirVisitor(ZipOutputStream output, Map<String, byte[]> hashs, Path sourceDir, String targetDir) {
            this.output = output;
            this.hashs = hashs;
            this.sourceDir = sourceDir;
            this.targetDir = targetDir;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            String dirName = IOHelper.toString((Path)this.sourceDir.relativize(dir));
            this.output.putNextEntry(this.newEntry(dirName + '/'));
            return super.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String fileName = IOHelper.toString((Path)this.sourceDir.relativize(file));
            if (this.hashs != null) {
                this.hashs.put(fileName, SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.MD5, (Path)file));
            }
            this.output.putNextEntry(this.newEntry(fileName));
            IOHelper.transfer((Path)file, (OutputStream)this.output);
            return super.visitFile(file, attrs);
        }

        private ZipEntry newEntry(String fileName) {
            return IOHelper.newZipEntry((String)(this.targetDir + "/" + fileName));
        }
    }
}

