/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.io.IOException;
import java.nio.file.Path;
import java.security.interfaces.ECPrivateKey;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.BinaryPipeline;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public abstract class LauncherBinary
extends BinaryPipeline {
    public final LaunchServer server;
    public final Path syncBinaryFile;
    private volatile byte[] digest;
    private volatile byte[] sign;

    protected LauncherBinary(LaunchServer server, Path binaryFile, String nameFormat) {
        super(server.dir.resolve("build"), nameFormat);
        this.server = server;
        this.syncBinaryFile = binaryFile;
    }

    public void build() throws IOException {
        this.build(this.syncBinaryFile, this.server.config.launcher.deleteTempFiles);
    }

    public final boolean exists() {
        return this.syncBinaryFile != null && IOHelper.isFile((Path)this.syncBinaryFile);
    }

    public final byte[] getDigest() {
        return this.digest;
    }

    public final byte[] getSign() {
        return this.sign;
    }

    public void init() {
    }

    public final boolean sync() throws IOException {
        boolean exists = this.exists();
        this.digest = exists ? SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA512, (byte[])IOHelper.read((Path)this.syncBinaryFile)) : null;
        this.sign = exists ? SecurityHelper.sign((byte[])IOHelper.read((Path)this.syncBinaryFile), (ECPrivateKey)this.server.privateKey) : null;
        return exists;
    }

    public static Path resolve(LaunchServer server, String ext) {
        return server.config.copyBinaries ? server.updatesDir.resolve(server.config.binaryName + ext) : server.dir.resolve(server.config.binaryName + ext);
    }
}

