/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import pro.gravit.launchserver.helper.SignHelper;
import pro.gravit.utils.helper.IOHelper;

public class SignerJar
implements AutoCloseable {
    private static final String MANIFEST_FN = "META-INF/MANIFEST.MF";
    private final String SIG_FN;
    private final String SIG_KEY_FN;
    private static final String DIGEST_HASH = "SHA-256-Digest";
    private final ZipOutputStream zos;
    private final Map<String, String> manifestAttributes;
    private String manifestHash;
    private String manifestMainHash;
    private final Map<String, String> fileDigests;
    private final Map<String, String> sectionDigests;
    private final Supplier<CMSSignedDataGenerator> gen;

    public SignerJar(ZipOutputStream out, Supplier<CMSSignedDataGenerator> gen, String sig_fn, String sig_key_fn) {
        this.zos = out;
        this.gen = gen;
        this.manifestAttributes = new LinkedHashMap<String, String>();
        this.fileDigests = new LinkedHashMap<String, String>();
        this.sectionDigests = new LinkedHashMap<String, String>();
        this.SIG_FN = "META-INF/".concat(sig_fn);
        this.SIG_KEY_FN = "META-INF/".concat(sig_key_fn);
    }

    public void addFileContents(String filename, byte[] contents) throws IOException {
        this.addFileContents(filename, (InputStream)new ByteArrayInputStream(contents));
    }

    public void addFileContents(String filename, InputStream contents) throws IOException {
        this.addFileContents(IOHelper.newZipEntry((String)filename), contents);
    }

    public void addFileContents(ZipEntry entry, byte[] contents) throws IOException {
        this.addFileContents(entry, (InputStream)new ByteArrayInputStream(contents));
    }

    public void addFileContents(ZipEntry entry, InputStream contents) throws IOException {
        this.zos.putNextEntry(entry);
        SignHelper.HashingNonClosingOutputStream out = new SignHelper.HashingNonClosingOutputStream(this.zos, SignHelper.hasher());
        IOHelper.transfer((InputStream)contents, (OutputStream)out);
        this.zos.closeEntry();
        this.fileDigests.put(entry.getName(), Base64.getEncoder().encodeToString(out.digest()));
    }

    public void addManifestAttribute(String name, String value) {
        this.manifestAttributes.put(name, value);
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.zos.close();
    }

    public void finish() throws IOException {
        this.writeManifest();
        byte[] sig = this.writeSigFile();
        this.writeSignature(sig);
        this.zos.finish();
    }

    public ZipOutputStream getZos() {
        return this.zos;
    }

    private String hashEntrySection(String name, Attributes attributes) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        manifest.write(o);
        int emptyLen = o.toByteArray().length;
        manifest.getEntries().put(name, attributes);
        manifest.write(o);
        byte[] ob = o.toByteArray();
        ob = Arrays.copyOfRange(ob, emptyLen, ob.length);
        return Base64.getEncoder().encodeToString(SignHelper.hasher().digest(ob));
    }

    private String hashMainSection(Attributes attributes) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putAll((Map<?, ?>)attributes);
        SignHelper.HashingNonClosingOutputStream o = new SignHelper.HashingNonClosingOutputStream(SignHelper.NULL, SignHelper.hasher());
        manifest.write(o);
        return Base64.getEncoder().encodeToString(o.digest());
    }

    private byte[] signSigFile(byte[] sigContents) throws Exception {
        CMSSignedDataGenerator gen = this.gen.get();
        CMSProcessableByteArray cmsData = new CMSProcessableByteArray(sigContents);
        CMSSignedData signedData = gen.generate((CMSTypedData)cmsData, false);
        return signedData.getEncoded();
    }

    private void writeManifest() throws IOException {
        this.zos.putNextEntry(IOHelper.newZipEntry((String)MANIFEST_FN));
        Manifest man = new Manifest();
        Attributes mainAttributes = man.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        for (Map.Entry<String, String> entry : this.manifestAttributes.entrySet()) {
            mainAttributes.put(new Attributes.Name(entry.getKey()), entry.getValue());
        }
        Attributes.Name digestAttr = new Attributes.Name(DIGEST_HASH);
        for (Map.Entry<String, String> entry : this.fileDigests.entrySet()) {
            Attributes attributes = new Attributes();
            man.getEntries().put(entry.getKey(), attributes);
            attributes.put(digestAttr, entry.getValue());
            this.sectionDigests.put(entry.getKey(), this.hashEntrySection(entry.getKey(), attributes));
        }
        SignHelper.HashingNonClosingOutputStream hashingNonClosingOutputStream = new SignHelper.HashingNonClosingOutputStream(this.zos, SignHelper.hasher());
        man.write(hashingNonClosingOutputStream);
        this.zos.closeEntry();
        this.manifestHash = Base64.getEncoder().encodeToString(hashingNonClosingOutputStream.digest());
        this.manifestMainHash = this.hashMainSection(man.getMainAttributes());
    }

    private byte[] writeSigFile() throws IOException {
        this.zos.putNextEntry(IOHelper.newZipEntry((String)this.SIG_FN));
        Manifest man = new Manifest();
        Attributes mainAttributes = man.getMainAttributes();
        mainAttributes.put(Attributes.Name.SIGNATURE_VERSION, "1.0");
        mainAttributes.put(new Attributes.Name("SHA-256-Digest-Manifest"), this.manifestHash);
        mainAttributes.put(new Attributes.Name("SHA-256-Digest-Manifest-Main-Attributes"), this.manifestMainHash);
        Attributes.Name digestAttr = new Attributes.Name(DIGEST_HASH);
        for (Map.Entry<String, String> entry : this.sectionDigests.entrySet()) {
            Attributes attributes = new Attributes();
            man.getEntries().put(entry.getKey(), attributes);
            attributes.put(digestAttr, entry.getValue());
        }
        man.write(this.zos);
        this.zos.closeEntry();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        man.write(baos);
        return baos.toByteArray();
    }

    private void writeSignature(byte[] sigFile) throws IOException {
        this.zos.putNextEntry(IOHelper.newZipEntry((String)this.SIG_KEY_FN));
        try {
            byte[] signature = this.signSigFile(sigFile);
            this.zos.write(signature);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Signing failed.", e);
        }
        this.zos.closeEntry();
    }
}

