/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.asm.ClassMetadataReader;
import pro.gravit.launchserver.asm.SafeClassWriter;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.utils.helper.IOHelper;

public class AdditionalFixesApplyTask
implements LauncherBuildTask {
    private final LaunchServer server;

    public AdditionalFixesApplyTask(LaunchServer server) {
        this.server = server;
    }

    @Override
    public String getName() {
        return "AdditionalFixesApply";
    }

    @Override
    public Path process(Path inputFile) throws IOException {
        Path out = this.server.launcherBinary.nextPath("post-fixed");
        try (ZipOutputStream output = new ZipOutputStream(IOHelper.newOutput((Path)out));){
            AdditionalFixesApplyTask.apply(inputFile, inputFile, output, this.server, e -> false, true);
        }
        return out;
    }

    public static void apply(Path inputFile, Path addFile, ZipOutputStream output, LaunchServer srv, Predicate<ZipEntry> excluder, boolean needFixes) throws IOException {
        try (ClassMetadataReader reader = new ClassMetadataReader();){
            reader.getCp().add(new JarFile(inputFile.toFile()));
            try (ZipInputStream input = IOHelper.newZipInput((Path)addFile);){
                ZipEntry e = input.getNextEntry();
                while (e != null) {
                    if (e.isDirectory() || excluder.test(e)) {
                        e = input.getNextEntry();
                        continue;
                    }
                    String filename = e.getName();
                    output.putNextEntry(IOHelper.newZipEntry((ZipEntry)e));
                    if (filename.endsWith(".class")) {
                        if (needFixes) {
                            byte[] bytes = AdditionalFixesApplyTask.classFix(input, reader, srv.config.launcher.stripLineNumbers);
                            output.write(bytes);
                        } else {
                            IOHelper.transfer((InputStream)input, (OutputStream)output);
                        }
                    } else {
                        IOHelper.transfer((InputStream)input, (OutputStream)output);
                    }
                    e = input.getNextEntry();
                }
            }
        }
    }

    private static byte[] classFix(InputStream input, ClassMetadataReader reader, boolean stripNumbers) throws IOException {
        ClassReader cr = new ClassReader(input);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, stripNumbers ? 6 : 4);
        SafeClassWriter cw = new SafeClassWriter(reader, 3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    @Override
    public boolean allowDelete() {
        return true;
    }
}

