/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary.tasks;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.launchserver.helper.SignHelper;
import pro.gravit.utils.helper.LogHelper;

public class CertificateAutogenTask
implements LauncherBuildTask {
    private LaunchServer server;
    public X509Certificate certificate;
    public X509CertificateHolder bcCertificate;
    public CMSSignedDataGenerator signedDataGenerator;

    public CertificateAutogenTask(LaunchServer server) {
        this.server = server;
    }

    @Override
    public String getName() {
        return "CertificateAutogen";
    }

    @Override
    public Path process(Path inputFile) throws IOException {
        if (this.signedDataGenerator != null) {
            return inputFile;
        }
        try {
            X500NameBuilder subject = new X500NameBuilder();
            subject.addRDN(BCStyle.CN, this.server.config.projectName.concat(" Autogenerated"));
            subject.addRDN(BCStyle.O, this.server.config.projectName);
            LocalDateTime startDate = LocalDate.now().atStartOfDay();
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(subject.build(), new BigInteger("0"), Date.from(startDate.atZone(ZoneId.systemDefault()).toInstant()), Date.from(startDate.plusDays(3650L).atZone(ZoneId.systemDefault()).toInstant()), new X500Name("CN=ca"), SubjectPublicKeyInfo.getInstance((Object)this.server.publicKey.getEncoded()));
            builder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_codeSigning));
            JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder("SHA256WITHECDSA");
            ContentSigner signer = csBuilder.build((PrivateKey)this.server.privateKey);
            this.bcCertificate = builder.build(signer);
            this.certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(this.bcCertificate);
            ArrayList<Certificate> chain = new ArrayList<Certificate>();
            chain.add(this.certificate);
            this.signedDataGenerator = SignHelper.createSignedDataGenerator(this.server.privateKey, this.certificate, chain, "SHA256WITHECDSA");
        }
        catch (CertificateException | CMSException | OperatorCreationException e) {
            LogHelper.error((Throwable)e);
        }
        return inputFile;
    }

    @Override
    public boolean allowDelete() {
        return false;
    }
}

