/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary.tasks;

import java.io.IOException;
import java.nio.file.Path;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.ParseException;
import proguard.ProGuard;

public class ProGuardBuildTask
implements LauncherBuildTask {
    private final LaunchServer server;

    public ProGuardBuildTask(LaunchServer server) {
        this.server = server;
    }

    @Override
    public String getName() {
        return "ProGuard";
    }

    @Override
    public Path process(Path inputFile) throws IOException {
        Path outputJar = this.server.launcherBinary.nextLowerPath(this);
        if (this.server.config.launcher.enabledProGuard) {
            Configuration proguard_cfg = new Configuration();
            ConfigurationParser parser = new ConfigurationParser(this.server.proguardConf.buildConfig(inputFile, outputJar), this.server.proguardConf.proguard.toFile(), System.getProperties());
            try {
                parser.parse(proguard_cfg);
                ProGuard proGuard = new ProGuard(proguard_cfg);
                proGuard.execute();
            }
            catch (ParseException e) {
                LogHelper.error((Throwable)e);
            }
        } else {
            IOHelper.copy((Path)inputFile, (Path)outputJar);
        }
        return outputJar;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }
}

