/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.dao;

import java.util.UUID;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.dao.impl.UserHibernateImpl;
import pro.gravit.utils.helper.LogHelper;

public class RegisterCommand
extends Command {
    public RegisterCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[login] [password]";
    }

    public String getUsageDescription() {
        return "Register new user";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 2);
        UserHibernateImpl user = new UserHibernateImpl();
        user.username = args[0];
        user.setPassword(args[1]);
        user.uuid = UUID.randomUUID();
        this.server.config.dao.userDAO.save(user);
        LogHelper.info((String)"User %s registered. UUID: %s", (Object[])new Object[]{user.username, user.uuid.toString()});
    }
}

