/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.service;

import java.net.SocketAddress;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.WebSocketService;
import pro.gravit.launchserver.socket.handlers.WebSocketFrameHandler;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class ClientsCommand
extends Command {
    public ClientsCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return null;
    }

    public String getUsageDescription() {
        return "Show all connected clients";
    }

    public void invoke(String ... args) {
        WebSocketService service = this.server.nettyServerSocketHandler.nettyServer.service;
        service.channels.forEach(channel -> {
            WebSocketFrameHandler frameHandler = (WebSocketFrameHandler)channel.pipeline().get(WebSocketFrameHandler.class);
            Client client = frameHandler.getClient();
            String ip = IOHelper.getIP((SocketAddress)channel.remoteAddress());
            if (!client.isAuth) {
                LogHelper.info((String)"Channel %s | connectUUID %s | checkSign %s", (Object[])new Object[]{ip, frameHandler.getConnectUUID(), client.checkSign ? "true" : "false"});
            } else {
                LogHelper.info((String)"Client name %s | ip %s | connectUUID %s", (Object[])new Object[]{client.username == null ? "null" : client.username, ip, frameHandler.getConnectUUID()});
                LogHelper.subInfo((String)"Data: checkSign %s | isSecure %s | auth_id %s", (Object[])new Object[]{client.checkSign ? "true" : "false", client.isSecure ? "true" : "false", client.auth_id});
                LogHelper.subInfo((String)"Permissions: %s (long %d)", (Object[])new Object[]{client.permissions == null ? "null" : client.permissions.toString(), client.permissions == null ? 0L : client.permissions.toLong()});
            }
        });
    }
}

