/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.dao.impl;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import pro.gravit.launcher.hwid.HWID;
import pro.gravit.launcher.hwid.OshiHWID;
import pro.gravit.launchserver.dao.HwidDAO;
import pro.gravit.launchserver.dao.UserHWID;
import pro.gravit.launchserver.dao.impl.UserHWIDImpl;

public class HibernateHwidDAOImpl
implements HwidDAO {
    private final SessionFactory factory;

    public HibernateHwidDAOImpl(SessionFactory factory) {
        this.factory = factory;
    }

    public List<UserHWIDImpl> findHWIDs(HWID hwid) {
        if (!(hwid instanceof OshiHWID)) {
            throw new UnsupportedOperationException();
        }
        OshiHWID oshiHWID = (OshiHWID)hwid;
        EntityManager em = this.factory.createEntityManager();
        em.getTransaction().begin();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery personCriteria = cb.createQuery(UserHWIDImpl.class);
        Root rootUser = personCriteria.from(UserHWIDImpl.class);
        personCriteria.select((Selection)rootUser).where((Expression)cb.or(new Predicate[]{cb.equal((Expression)rootUser.get("totalMemory"), (Object)oshiHWID.totalMemory), cb.equal((Expression)rootUser.get("HWDiskSerial"), (Object)oshiHWID.HWDiskSerial), cb.equal((Expression)rootUser.get("serialNumber"), (Object)oshiHWID.serialNumber), cb.equal((Expression)rootUser.get("processorID"), (Object)oshiHWID.processorID), cb.equal((Expression)rootUser.get("macAddr"), (Object)oshiHWID.macAddr)}));
        List list = em.createQuery(personCriteria).getResultList();
        em.close();
        return list;
    }

    @Override
    public UserHWIDImpl findById(long id) {
        try (Session s = this.factory.openSession();){
            UserHWIDImpl userHWIDImpl = (UserHWIDImpl)s.get(UserHWIDImpl.class, (Serializable)Long.valueOf(id));
            return userHWIDImpl;
        }
    }

    @Override
    public void save(UserHWID user) {
        try (Session session = this.factory.openSession();){
            Transaction tx1 = session.beginTransaction();
            session.save((Object)user);
            tx1.commit();
        }
    }

    @Override
    public void update(UserHWID user) {
        try (Session session = this.factory.openSession();){
            Transaction tx1 = session.beginTransaction();
            session.update((Object)user);
            tx1.commit();
        }
    }

    @Override
    public void delete(UserHWID user) {
        try (Session session = this.factory.openSession();){
            Transaction tx1 = session.beginTransaction();
            session.delete((Object)user);
            tx1.commit();
        }
    }

    @Override
    public List<UserHWID> findAll() {
        try (Session s = this.factory.openSession();){
            List list = s.createQuery("From user_hwids").list();
            return list;
        }
    }
}

