/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.dao.impl;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import pro.gravit.launchserver.dao.User;
import pro.gravit.launchserver.dao.UserDAO;
import pro.gravit.launchserver.dao.impl.UserHibernateImpl;

public class HibernateUserDAOImpl
implements UserDAO {
    private final SessionFactory factory;

    public HibernateUserDAOImpl(SessionFactory factory) {
        this.factory = factory;
    }

    @Override
    public UserHibernateImpl findById(int id) {
        try (Session s = this.factory.openSession();){
            UserHibernateImpl userHibernateImpl = (UserHibernateImpl)s.get(UserHibernateImpl.class, (Serializable)Integer.valueOf(id));
            return userHibernateImpl;
        }
    }

    @Override
    public UserHibernateImpl findByUsername(String username) {
        EntityManager em = this.factory.createEntityManager();
        em.getTransaction().begin();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery personCriteria = cb.createQuery(UserHibernateImpl.class);
        Root rootUser = personCriteria.from(UserHibernateImpl.class);
        personCriteria.select((Selection)rootUser).where((Expression)cb.equal((Expression)rootUser.get("username"), (Object)username));
        List ret = em.createQuery(personCriteria).getResultList();
        em.close();
        return ret.size() == 0 ? null : (UserHibernateImpl)ret.get(0);
    }

    @Override
    public UserHibernateImpl findByUUID(UUID uuid) {
        EntityManager em = this.factory.createEntityManager();
        em.getTransaction().begin();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery personCriteria = cb.createQuery(UserHibernateImpl.class);
        Root rootUser = personCriteria.from(UserHibernateImpl.class);
        personCriteria.select((Selection)rootUser).where((Expression)cb.equal((Expression)rootUser.get("uuid"), (Object)uuid));
        List ret = em.createQuery(personCriteria).getResultList();
        em.close();
        return ret.size() == 0 ? null : (UserHibernateImpl)ret.get(0);
    }

    @Override
    public void save(User user) {
        try (Session session = this.factory.openSession();){
            Transaction tx1 = session.beginTransaction();
            session.save((Object)user);
            tx1.commit();
        }
    }

    @Override
    public void update(User user) {
        try (Session session = this.factory.openSession();){
            Transaction tx1 = session.beginTransaction();
            session.update((Object)user);
            tx1.commit();
        }
    }

    @Override
    public void delete(User user) {
        try (Session session = this.factory.openSession();){
            Transaction tx1 = session.beginTransaction();
            session.delete((Object)user);
            tx1.commit();
        }
    }

    @Override
    public List<User> findAll() {
        try (Session s = this.factory.openSession();){
            List list = s.createQuery("From User").list();
            return list;
        }
    }
}

