/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.dao.impl;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launchserver.dao.User;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

@Entity
@Table(name="users")
public class UserHibernateImpl
implements User {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Column(unique=true)
    public String username;
    public String email;
    @Column(unique=true)
    public UUID uuid;
    @Column(name="password")
    private byte[] password;
    private String accessToken;
    public String serverID;
    private String password_salt;
    public long permissions;

    @Override
    public void setPassword(String password) {
        MessageDigest digest;
        this.password_salt = SecurityHelper.randomStringAESKey();
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            LogHelper.error((Throwable)e);
            return;
        }
        this.password = digest.digest(password.concat(this.password_salt).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean verifyPassword(String password) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            LogHelper.error((Throwable)e);
            return false;
        }
        byte[] enpassword = digest.digest(password.concat(this.password_salt).getBytes(StandardCharsets.UTF_8));
        return Arrays.equals(enpassword, this.password);
    }

    @Override
    public ClientPermissions getPermissions() {
        return new ClientPermissions(this.permissions);
    }

    @Override
    public void setPermissions(ClientPermissions permissions) {
        this.permissions = permissions.toLong();
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getServerID() {
        return this.serverID;
    }

    @Override
    public void setServerID(String serverID) {
        this.serverID = serverID;
    }
}

