/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.dao.provider;

import java.nio.file.Paths;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.dao.impl.HibernateHwidDAOImpl;
import pro.gravit.launchserver.dao.impl.HibernateUserDAOImpl;
import pro.gravit.launchserver.dao.impl.UserHWIDImpl;
import pro.gravit.launchserver.dao.impl.UserHibernateImpl;
import pro.gravit.launchserver.dao.provider.DaoProvider;
import pro.gravit.utils.helper.CommonHelper;

public class HibernateDaoProvider
extends DaoProvider {
    public String driver;
    public String url;
    public String username;
    public String password;
    public String dialect;
    public String pool_size;
    public String hibernateConfig;
    public boolean parallelHibernateInit;
    private transient SessionFactory sessionFactory;

    @Override
    public void init(LaunchServer server) {
        Runnable init = () -> {
            Configuration cfg = new Configuration().addAnnotatedClass(UserHibernateImpl.class).addAnnotatedClass(UserHWIDImpl.class).setProperty("hibernate.connection.driver_class", this.driver).setProperty("hibernate.connection.url", this.url).setProperty("hibernate.connection.username", this.username).setProperty("hibernate.connection.password", this.password).setProperty("hibernate.connection.pool_size", this.pool_size);
            if (this.dialect != null) {
                cfg.setProperty("hibernate.dialect", this.dialect);
            }
            if (this.hibernateConfig != null) {
                cfg.configure(Paths.get(this.hibernateConfig, new String[0]).toFile());
            }
            this.sessionFactory = cfg.buildSessionFactory();
            this.userDAO = new HibernateUserDAOImpl(this.sessionFactory);
            this.hwidDao = new HibernateHwidDAOImpl(this.sessionFactory);
        };
        if (this.parallelHibernateInit) {
            CommonHelper.newThread((String)"Hibernate Thread", (boolean)true, (Runnable)init);
        } else {
            init.run();
        }
    }
}

