/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.helper;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import pro.gravit.utils.helper.IOHelper;

public class SignHelper {
    public static final OutputStream NULL = new OutputStream(){

        public String toString() {
            return "NullOutputStream";
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void close() {
        }
    };
    public static final String hashFunctionName = "SHA-256";

    private SignHelper() {
    }

    public static KeyStore getStore(Path file, String storepass, String algo) throws IOException {
        try {
            KeyStore st = KeyStore.getInstance(algo);
            st.load(IOHelper.newInput((Path)file), storepass != null ? storepass.toCharArray() : null);
            return st;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException(e);
        }
    }

    public static CMSSignedDataGenerator createSignedDataGenerator(KeyStore keyStore, String keyAlias, String signAlgo, String keyPassword) throws KeyStoreException, OperatorCreationException, CertificateEncodingException, UnrecoverableKeyException, NoSuchAlgorithmException, CMSException {
        ArrayList<Certificate> certChain = new ArrayList<Certificate>(Arrays.asList(keyStore.getCertificateChain(keyAlias)));
        JcaCertStore certStore = new JcaCertStore(certChain);
        Certificate cert = keyStore.getCertificate(keyAlias);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyPassword != null ? keyPassword.toCharArray() : null);
        ContentSigner signer = new JcaContentSignerBuilder(signAlgo).setProvider("BC").build(privateKey);
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
        SignerInfoGenerator sig = new JcaSignerInfoGeneratorBuilder(dcp).build(signer, (X509Certificate)cert);
        generator.addSignerInfoGenerator(sig);
        generator.addCertificates((Store)certStore);
        return generator;
    }

    public static CMSSignedDataGenerator createSignedDataGenerator(PrivateKey privateKey, Certificate cert, List<Certificate> certChain, String signAlgo) throws OperatorCreationException, CertificateEncodingException, CMSException {
        JcaCertStore certStore = new JcaCertStore(certChain);
        ContentSigner signer = new JcaContentSignerBuilder(signAlgo).setProvider("BC").build(privateKey);
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
        SignerInfoGenerator sig = new JcaSignerInfoGeneratorBuilder(dcp).build(signer, (X509Certificate)cert);
        generator.addSignerInfoGenerator(sig);
        generator.addCertificates((Store)certStore);
        return generator;
    }

    public static MessageDigest hasher() {
        try {
            return MessageDigest.getInstance(hashFunctionName);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static class HashingNonClosingOutputStream
    extends HashingOutputStream {
        public HashingNonClosingOutputStream(OutputStream out, MessageDigest hasher) {
            super(out, hasher);
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static class HashingOutputStream
    extends OutputStream {
        public final OutputStream out;
        public final MessageDigest hasher;

        public HashingOutputStream(OutputStream out, MessageDigest hasher) {
            this.out = out;
            this.hasher = hasher;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
            this.hasher.update(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.hasher.update(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            this.hasher.update((byte)b);
        }

        public byte[] digest() {
            return this.hasher.digest();
        }
    }
}

