/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket;

import com.google.gson.Gson;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelMatchers;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Type;
import java.net.SocketAddress;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.events.ExceptionEvent;
import pro.gravit.launcher.events.request.ErrorRequestEvent;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.WebSocketServerResponse;
import pro.gravit.launchserver.socket.response.admin.AddLogListenerResponse;
import pro.gravit.launchserver.socket.response.admin.ExecCommandResponse;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.launchserver.socket.response.auth.CheckServerResponse;
import pro.gravit.launchserver.socket.response.auth.GetAvailabilityAuthResponse;
import pro.gravit.launchserver.socket.response.auth.JoinServerResponse;
import pro.gravit.launchserver.socket.response.auth.ProfilesResponse;
import pro.gravit.launchserver.socket.response.auth.RegisterResponse;
import pro.gravit.launchserver.socket.response.auth.RestoreSessionResponse;
import pro.gravit.launchserver.socket.response.auth.SetPasswordResponse;
import pro.gravit.launchserver.socket.response.auth.SetProfileResponse;
import pro.gravit.launchserver.socket.response.profile.BatchProfileByUsername;
import pro.gravit.launchserver.socket.response.profile.ProfileByUUIDResponse;
import pro.gravit.launchserver.socket.response.profile.ProfileByUsername;
import pro.gravit.launchserver.socket.response.secure.GetSecureTokenResponse;
import pro.gravit.launchserver.socket.response.secure.VerifySecureTokenResponse;
import pro.gravit.launchserver.socket.response.update.LauncherResponse;
import pro.gravit.launchserver.socket.response.update.UpdateListResponse;
import pro.gravit.launchserver.socket.response.update.UpdateResponse;
import pro.gravit.utils.BiHookSet;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class WebSocketService {
    public final ChannelGroup channels;
    public static final ProviderMap<WebSocketServerResponse> providers = new ProviderMap();
    public final BiHookSet<WebSocketRequestContext, ChannelHandlerContext> hook = new BiHookSet();
    private final LaunchServer server;
    private final Gson gson;

    public WebSocketService(ChannelGroup channels, LaunchServer server) {
        this.channels = channels;
        this.server = server;
        this.gson = Launcher.gsonManager.gson;
    }

    public void process(ChannelHandlerContext ctx, TextWebSocketFrame frame, Client client, String ip) {
        String request = frame.text();
        WebSocketServerResponse response = (WebSocketServerResponse)this.gson.fromJson(request, WebSocketServerResponse.class);
        this.process(ctx, response, client, ip);
    }

    void process(ChannelHandlerContext ctx, WebSocketServerResponse response, Client client, String ip) {
        WebSocketRequestContext context = new WebSocketRequestContext(response, client, ip);
        if (this.hook.hook((Object)context, (Object)ctx)) {
            return;
        }
        if (response instanceof SimpleResponse) {
            SimpleResponse simpleResponse = (SimpleResponse)response;
            simpleResponse.server = this.server;
            simpleResponse.service = this;
            simpleResponse.ctx = ctx;
            simpleResponse.ip = ip != null ? ip : IOHelper.getIP((SocketAddress)ctx.channel().remoteAddress());
        }
        try {
            response.execute(ctx, client);
        }
        catch (Exception e) {
            LogHelper.error((Throwable)e);
            Object event = this.server.config.netty.sendExceptionEnabled ? new ExceptionEvent(e) : new ErrorRequestEvent("Fatal server error. Contact administrator");
            if (response instanceof SimpleResponse) {
                event.requestUUID = ((SimpleResponse)response).requestUUID;
            }
            this.sendObject(ctx, event);
        }
    }

    public void registerClient(Channel channel) {
        this.channels.add((Object)channel);
    }

    public static void registerResponses() {
        providers.register("auth", AuthResponse.class);
        providers.register("checkServer", CheckServerResponse.class);
        providers.register("joinServer", JoinServerResponse.class);
        providers.register("profiles", ProfilesResponse.class);
        providers.register("launcher", LauncherResponse.class);
        providers.register("updateList", UpdateListResponse.class);
        providers.register("cmdExec", ExecCommandResponse.class);
        providers.register("setProfile", SetProfileResponse.class);
        providers.register("addLogListener", AddLogListenerResponse.class);
        providers.register("update", UpdateResponse.class);
        providers.register("restoreSession", RestoreSessionResponse.class);
        providers.register("batchProfileByUsername", BatchProfileByUsername.class);
        providers.register("profileByUsername", ProfileByUsername.class);
        providers.register("profileByUUID", ProfileByUUIDResponse.class);
        providers.register("getSecureToken", GetSecureTokenResponse.class);
        providers.register("verifySecureToken", VerifySecureTokenResponse.class);
        providers.register("getAvailabilityAuth", GetAvailabilityAuthResponse.class);
        providers.register("register", RegisterResponse.class);
        providers.register("setPassword", SetPasswordResponse.class);
    }

    public void sendObject(ChannelHandlerContext ctx, Object obj) {
        ctx.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, WebSocketEvent.class)), ctx.voidPromise());
    }

    public void sendObject(ChannelHandlerContext ctx, Object obj, Type type) {
        ctx.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, type)), ctx.voidPromise());
    }

    public void sendObject(Channel channel, Object obj) {
        channel.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, WebSocketEvent.class)), channel.voidPromise());
    }

    public void sendObject(Channel channel, Object obj, Type type) {
        channel.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, type)), channel.voidPromise());
    }

    public void sendObjectAll(Object obj) {
        for (Channel ch : this.channels) {
            ch.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, WebSocketEvent.class)), ch.voidPromise());
        }
    }

    public void sendObjectAll(Object obj, Type type) {
        for (Channel ch : this.channels) {
            ch.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, type)), ch.voidPromise());
        }
    }

    public void sendObjectAndClose(ChannelHandlerContext ctx, Object obj) {
        ctx.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, WebSocketEvent.class))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendObjectAndClose(ChannelHandlerContext ctx, Object obj, Type type) {
        ctx.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, type))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendEvent(EventResult obj) {
        this.channels.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson((Object)obj)), ChannelMatchers.all(), true);
    }

    public static class EventResult
    implements WebSocketEvent {
        public String getType() {
            return "event";
        }
    }

    public static class WebSocketRequestContext {
        public final WebSocketServerResponse response;
        public final Client client;
        public final String ip;

        public WebSocketRequestContext(WebSocketServerResponse response, Client client, String ip) {
            this.response = response;
            this.client = client;
            this.ip = ip;
        }
    }
}

