/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.profile;

import io.netty.channel.ChannelHandlerContext;
import java.util.UUID;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.BatchProfileByUsernameRequestEvent;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.profile.ProfileByUUIDResponse;
import pro.gravit.utils.helper.LogHelper;

public class BatchProfileByUsername
extends SimpleResponse {
    Entry[] list;

    @Override
    public String getType() {
        return "batchProfileByUsername";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) throws Exception {
        BatchProfileByUsernameRequestEvent result = new BatchProfileByUsernameRequestEvent();
        result.playerProfiles = new PlayerProfile[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            UUID uuid;
            if (client.auth == null) {
                LogHelper.warning((String)"Client auth is null. Using default.");
                uuid = this.server.config.getAuthProviderPair().handler.usernameToUUID(this.list[i].username);
            } else {
                uuid = client.auth.handler.usernameToUUID(this.list[i].username);
            }
            result.playerProfiles[i] = ProfileByUUIDResponse.getProfile(uuid, this.list[i].username, this.list[i].client, client.auth.textureProvider);
        }
        this.sendResult((RequestEvent)result);
    }

    static class Entry {
        String username;
        String client;

        Entry() {
        }
    }
}

