/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.update;

import io.netty.channel.ChannelHandlerContext;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.UpdateRequestEvent;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.utils.helper.IOHelper;

public class UpdateResponse
extends SimpleResponse {
    public String dirName;

    @Override
    public String getType() {
        return "update";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        HashedDir dir;
        if (!client.isAuth || client.type != AuthResponse.ConnectTypes.CLIENT || client.profile == null) {
            this.sendError("Access denied");
            return;
        }
        if (!client.permissions.canAdmin) {
            for (ClientProfile p : this.server.getProfiles()) {
                if (!client.profile.getTitle().equals(p.getTitle()) || p.isWhitelistContains(client.username)) continue;
                this.sendError("You don't download this folder");
                return;
            }
        }
        if ((dir = this.server.updatesDirMap.get(this.dirName)) == null) {
            this.sendError(String.format("Directory %s not found", this.dirName));
            return;
        }
        String url = this.server.config.netty.downloadURL.replace("%dirname%", IOHelper.urlEncode((String)this.dirName));
        boolean zip = false;
        if (this.server.config.netty.bindings.get(this.dirName) != null) {
            LaunchServerConfig.NettyUpdatesBind bind = this.server.config.netty.bindings.get(this.dirName);
            url = bind.url;
            zip = bind.zip;
        }
        this.sendResult((RequestEvent)new UpdateRequestEvent(dir, url, zip));
    }
}

