/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.handler;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.net.URL;
import java.util.UUID;
import pro.gravit.launcher.HTTPRequest;
import pro.gravit.launcher.Launcher;
import pro.gravit.launchserver.auth.handler.CachedAuthHandler;

public class JsonAuthHandler
extends CachedAuthHandler {
    public URL getUrl;
    public URL updateAuthUrl;
    public URL updateServerIdUrl;
    public String apiKey;

    @Override
    protected CachedAuthHandler.Entry fetchEntry(String username) throws IOException {
        return (CachedAuthHandler.Entry)Launcher.gsonManager.gson.fromJson(HTTPRequest.jsonRequest((JsonElement)Launcher.gsonManager.gson.toJsonTree((Object)new EntryRequestByUsername(username, this.apiKey)), (URL)this.getUrl), CachedAuthHandler.Entry.class);
    }

    @Override
    protected CachedAuthHandler.Entry fetchEntry(UUID uuid) throws IOException {
        return (CachedAuthHandler.Entry)Launcher.gsonManager.gson.fromJson(HTTPRequest.jsonRequest((JsonElement)Launcher.gsonManager.gson.toJsonTree((Object)new EntryRequestByUUID(uuid, this.apiKey)), (URL)this.getUrl), CachedAuthHandler.Entry.class);
    }

    @Override
    protected boolean updateAuth(UUID uuid, String username, String accessToken) throws IOException {
        return ((SuccessResponse)Launcher.gsonManager.gson.fromJson((JsonElement)HTTPRequest.jsonRequest((JsonElement)Launcher.gsonManager.gson.toJsonTree((Object)new UpdateAuthRequest((UUID)uuid, (String)username, (String)accessToken, (String)this.apiKey)), (URL)this.updateAuthUrl), SuccessResponse.class)).success;
    }

    @Override
    protected boolean updateServerID(UUID uuid, String serverID) throws IOException {
        return ((SuccessResponse)Launcher.gsonManager.gson.fromJson((JsonElement)HTTPRequest.jsonRequest((JsonElement)Launcher.gsonManager.gson.toJsonTree((Object)new UpdateServerIDRequest((UUID)uuid, (String)serverID, (String)this.apiKey)), (URL)this.updateServerIdUrl), SuccessResponse.class)).success;
    }

    @Override
    public void close() {
    }

    public static class SuccessResponse {
        public boolean success;
    }

    public static class UpdateServerIDRequest {
        public final UUID uuid;
        public final String serverID;
        public final String apiKey;

        public UpdateServerIDRequest(UUID uuid, String serverID, String apiKey) {
            this.uuid = uuid;
            this.serverID = serverID;
            this.apiKey = apiKey;
        }
    }

    public static class UpdateAuthRequest {
        public final UUID uuid;
        public final String username;
        public final String accessToken;
        public final String apiKey;

        public UpdateAuthRequest(UUID uuid, String username, String accessToken, String apiKey) {
            this.uuid = uuid;
            this.username = username;
            this.accessToken = accessToken;
            this.apiKey = apiKey;
        }
    }

    public static class EntryRequestByUUID {
        public final UUID uuid;
        public final String apiKey;

        public EntryRequestByUUID(UUID uuid, String apiKey) {
            this.uuid = uuid;
            this.apiKey = apiKey;
        }
    }

    public static class EntryRequestByUsername {
        public final String username;
        public final String apiKey;

        public EntryRequestByUsername(String username, String apiKey) {
            this.username = username;
            this.apiKey = apiKey;
        }
    }
}

