/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.modules.impl;

import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModuleInfo;
import pro.gravit.launcher.modules.impl.SimpleModuleManager;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.modules.impl.LaunchServerCoreModule;
import pro.gravit.launchserver.modules.impl.LaunchServerInitContext;
import pro.gravit.utils.helper.LogHelper;

public class LaunchServerModulesManager
extends SimpleModuleManager {
    public final LaunchServerCoreModule coreModule = new LaunchServerCoreModule();

    public LaunchServerModulesManager(Path modulesDir, Path configDir, LauncherTrustManager trustManager) {
        super(modulesDir, configDir, trustManager);
        this.loadModule(this.coreModule);
    }

    public void fullInitializedLaunchServer(LaunchServer server) {
        this.initContext = new LaunchServerInitContext(server);
    }

    public void printModulesInfo() {
        for (LauncherModule module : this.modules) {
            X509Certificate cert;
            LauncherModuleInfo info = module.getModuleInfo();
            LauncherTrustManager.CheckClassResult checkStatus = module.getCheckResult();
            LogHelper.info((String)"[MODULE] %s v: %s p: %d deps: %s sig: %s", (Object[])new Object[]{info.name, info.version.getVersionString(), info.priority, Arrays.toString(info.dependencies), checkStatus == null ? "null" : checkStatus.type});
            if (checkStatus != null && checkStatus.endCertificate != null) {
                cert = checkStatus.endCertificate;
                LogHelper.info((String)"[MODULE CERT] Module signer: %s", (Object[])new Object[]{cert.getSubjectDN().getName()});
            }
            if (checkStatus == null || checkStatus.rootCertificate == null) continue;
            cert = checkStatus.rootCertificate;
            LogHelper.info((String)"[MODULE CERT] Module signer CA: %s", (Object[])new Object[]{cert.getSubjectDN().getName()});
        }
    }

    public final boolean verifyClassCheckResult(LauncherTrustManager.CheckClassResult result) {
        return true;
    }

    public LauncherModule getCoreModule() {
        return this.coreModule;
    }
}

