/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.socket.NettyConnectContext;
import pro.gravit.launchserver.socket.NettyObjectFactory;
import pro.gravit.launchserver.socket.WebSocketService;
import pro.gravit.launchserver.socket.handlers.NettyIpForwardHandler;
import pro.gravit.launchserver.socket.handlers.NettyWebAPIHandler;
import pro.gravit.launchserver.socket.handlers.WebSocketFrameHandler;
import pro.gravit.launchserver.socket.handlers.fileserver.FileServerHandler;
import pro.gravit.utils.BiHookSet;
import pro.gravit.utils.helper.LogHelper;

public class LauncherNettyServer
implements AutoCloseable {
    private static final String WEBSOCKET_PATH = "/api";
    public final ServerBootstrap serverBootstrap;
    public final EventLoopGroup bossGroup;
    public final EventLoopGroup workerGroup;
    public final WebSocketService service;
    public final BiHookSet<NettyConnectContext, SocketChannel> pipelineHook = new BiHookSet();

    public LauncherNettyServer(final LaunchServer server) {
        final LaunchServerConfig.NettyConfig config = server.config.netty;
        NettyObjectFactory.setUsingEpoll(config.performance.usingEpoll);
        if (config.performance.usingEpoll) {
            LogHelper.debug((String)"Netty: Epoll enabled");
        }
        if (config.performance.usingEpoll && !Epoll.isAvailable()) {
            LogHelper.error((String)"Epoll is not available: (netty,perfomance.usingEpoll configured wrongly)", (Object[])new Object[]{Epoll.unavailabilityCause()});
        }
        this.bossGroup = NettyObjectFactory.newEventLoopGroup(config.performance.bossThread, "LauncherNettyServer.bossGroup");
        this.workerGroup = NettyObjectFactory.newEventLoopGroup(config.performance.workerThread, "LauncherNettyServer.workerGroup");
        this.serverBootstrap = new ServerBootstrap();
        this.service = new WebSocketService((ChannelGroup)new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE), server);
        ((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.bossGroup, this.workerGroup).channelFactory(NettyObjectFactory.getServerSocketChannelFactory())).handler((ChannelHandler)new LoggingHandler(config.logLevel))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                NettyConnectContext context = new NettyConnectContext();
                pipeline.addLast("http-codec", (ChannelHandler)new HttpServerCodec());
                pipeline.addLast("http-codec-compressor", (ChannelHandler)new HttpObjectAggregator(server.config.netty.performance.maxWebSocketRequestBytes));
                if (server.config.netty.ipForwarding) {
                    pipeline.addLast("forward-http", (ChannelHandler)new NettyIpForwardHandler(context));
                }
                pipeline.addLast("websock-comp", (ChannelHandler)new WebSocketServerCompressionHandler());
                pipeline.addLast("websock-codec", (ChannelHandler)new WebSocketServerProtocolHandler(LauncherNettyServer.WEBSOCKET_PATH, null, true, server.config.netty.performance.maxWebSocketRequestBytes));
                if (!server.config.netty.disableWebApiInterface) {
                    pipeline.addLast("webapi", (ChannelHandler)new NettyWebAPIHandler(context));
                }
                if (server.config.netty.fileServerEnabled) {
                    pipeline.addLast("fileserver", (ChannelHandler)new FileServerHandler(server.updatesDir, true, config.showHiddenFiles));
                }
                pipeline.addLast("launchserver", (ChannelHandler)new WebSocketFrameHandler(context, server, LauncherNettyServer.this.service));
                LauncherNettyServer.this.pipelineHook.hook((Object)context, (Object)ch);
            }
        });
    }

    public ChannelFuture bind(InetSocketAddress address) {
        return this.serverBootstrap.bind((SocketAddress)address);
    }

    @Override
    public void close() {
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
    }
}

