/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.handlers.fileserver;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import pro.gravit.launchserver.socket.handlers.ContentType;
import pro.gravit.launchserver.socket.handlers.fileserver.ClosingChannelFutureListener;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.VerifyHelper;

public class FileServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    public static final DateTimeFormatter dateFormatter;
    public static final String READ = "r";
    public static final int HTTP_CACHE_SECONDS;
    private static final boolean OLD_ALGO;
    private static final ContentType TYPE_PROBE;
    private static final Pattern ALLOWED_FILE_NAME;
    private final Path base;
    private final boolean fullOut;
    private final boolean showHiddenFiles;

    public FileServerHandler(Path base, boolean fullOut, boolean showHiddenFiles) {
        this.base = base;
        this.fullOut = fullOut;
        this.showHiddenFiles = showHiddenFiles;
    }

    private static void sendListing(ChannelHandlerContext ctx, File dir, String dirPath, boolean showHidden) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTF-8");
        StringBuilder buf = new StringBuilder().append("<!DOCTYPE html>\r\n").append("<html><head><meta charset='utf-8' /><title>").append("Listing of: ").append(dirPath).append("</title></head><body>\r\n").append("<h3>Listing of: ").append(dirPath).append("</h3>\r\n").append("<ul>").append("<li><a href=\"../\">..</a></li>\r\n");
        for (File f : Objects.requireNonNull(dir.listFiles())) {
            String name;
            if (f.isHidden() && !showHidden || !f.canRead() || !ALLOWED_FILE_NAME.matcher(name = f.getName()).matches()) continue;
            buf.append("<li><a href=\"").append(name).append("\">").append(name).append("</a></li>\r\n");
        }
        buf.append("</ul></body></html>\r\n");
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)buf, (Charset)CharsetUtil.UTF_8);
        response.content().writeBytes(buffer);
        buffer.release();
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendRedirect(ChannelHandlerContext ctx, String newUri) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FOUND);
        response.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)newUri);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendNotModified(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        FileServerHandler.setDateHeader((FullHttpResponse)response);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void setDateHeader(FullHttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)dateFormatter.format(Instant.ofEpochMilli(System.currentTimeMillis())));
    }

    private static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        LocalDateTime time = LocalDateTime.now(Clock.systemUTC());
        response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)dateFormatter.format(time));
        response.headers().set((CharSequence)HttpHeaderNames.EXPIRES, (Object)dateFormatter.format(time.plus(HTTP_CACHE_SECONDS, ChronoUnit.SECONDS)));
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)("private, max-age=" + HTTP_CACHE_SECONDS));
        response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)dateFormatter.format(Instant.ofEpochMilli(fileToCache.lastModified())));
    }

    private static void setContentTypeHeader(HttpResponse response, File file) {
        String contentType = TYPE_PROBE.forPath(file);
        if (contentType != null) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        ChannelFuture lastContentFuture;
        RandomAccessFile raf;
        File file;
        block21: {
            String path;
            if (!request.decoderResult().isSuccess()) {
                FileServerHandler.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (request.method() != HttpMethod.GET) {
                FileServerHandler.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                return;
            }
            String uri = request.uri();
            try {
                path = Paths.get(new URI(uri).getPath(), new String[0]).normalize().toString().substring(1);
            }
            catch (URISyntaxException e) {
                FileServerHandler.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            file = this.base.resolve(path).toFile();
            if (file.isHidden() && !this.showHiddenFiles || !file.exists()) {
                FileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                return;
            }
            if (file.isDirectory()) {
                if (this.fullOut) {
                    if (uri.endsWith("/")) {
                        FileServerHandler.sendListing(ctx, file, uri, this.showHiddenFiles);
                    } else {
                        FileServerHandler.sendRedirect(ctx, uri + "/");
                    }
                } else {
                    FileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                }
                return;
            }
            if (!file.isFile()) {
                FileServerHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                return;
            }
            String ifModifiedSince = request.headers().get((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
            if (ifModifiedSince != null && !ifModifiedSince.isEmpty()) {
                TemporalAccessor ifModifiedSinceDate = dateFormatter.parse(ifModifiedSince);
                try {
                    long ifModifiedSinceDateSeconds = ifModifiedSinceDate.getLong(ChronoField.INSTANT_SECONDS);
                    long fileLastModifiedSeconds = file.lastModified() / 1000L;
                    if (ifModifiedSinceDateSeconds == fileLastModifiedSeconds) {
                        FileServerHandler.sendNotModified(ctx);
                        return;
                    }
                }
                catch (UnsupportedTemporalTypeException e) {
                    if (!LogHelper.isDebugEnabled()) break block21;
                    LogHelper.warning((String)"Request access If-Modifed-Since: %s not parsed correctly", (Object[])new Object[]{ifModifiedSince});
                }
            }
        }
        try {
            raf = new RandomAccessFile(file, READ);
        }
        catch (FileNotFoundException ignore) {
            FileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        long fileLength = raf.length();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpUtil.setContentLength((HttpMessage)response, (long)fileLength);
        FileServerHandler.setContentTypeHeader((HttpResponse)response, file);
        FileServerHandler.setDateAndCacheHeaders((HttpResponse)response, file);
        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        ctx.write((Object)response);
        if (OLD_ALGO) {
            ChannelFuture sendFileFuture = ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
            lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            lastContentFuture.addListener((GenericFutureListener)new ClosingChannelFutureListener(raf));
        } else {
            ChannelFuture sendFileFuture;
            lastContentFuture = sendFileFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
        }
        if (!HttpUtil.isKeepAlive((HttpMessage)request)) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            FileServerHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    static {
        HTTP_CACHE_SECONDS = VerifyHelper.verifyInt((int)Integer.parseInt(System.getProperty("launcher.fileserver.cachesec", "60")), (IntPredicate)VerifyHelper.NOT_NEGATIVE, (String)"HttpCache seconds should be positive");
        OLD_ALGO = Boolean.parseBoolean(System.getProperty("launcher.fileserver.oldalgo", "true"));
        TYPE_PROBE = Arrays.stream(ContentType.values()).filter(e -> e.name().toLowerCase(Locale.US).equals(System.getProperty("launcher.fileserver.typeprobe", "nio"))).findFirst().orElse(ContentType.UNIVERSAL);
        ALLOWED_FILE_NAME = Pattern.compile("[^-\\._]?[^<>&\\\"]*");
        dateFormatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).withZone(ZoneId.of("UTC"));
    }
}

