/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.ExitRequestEvent;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.handlers.WebSocketFrameHandler;
import pro.gravit.launchserver.socket.response.SimpleResponse;

public class ExitResponse
extends SimpleResponse {
    public boolean exitAll;
    public String username;

    @Override
    public String getType() {
        return "exit";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) throws Exception {
        if (!(this.username == null || client.isAuth && client.permissions != null && client.permissions.isPermission(ClientPermissions.PermissionConsts.ADMIN))) {
            this.sendError("Permissions denied");
            return;
        }
        if (this.username == null) {
            if (client.session == null && this.exitAll) {
                this.sendError("Session invalid");
                return;
            }
            WebSocketFrameHandler handler = (WebSocketFrameHandler)ctx.pipeline().get(WebSocketFrameHandler.class);
            if (handler == null) {
                this.sendError("Exit internal error");
                return;
            }
            Client newClient = new Client(null);
            newClient.checkSign = client.checkSign;
            handler.setClient(newClient);
            if (client.session != null) {
                this.server.sessionManager.remove(client.session);
            }
            if (this.exitAll) {
                this.service.forEachActiveChannels((channel, webSocketFrameHandler) -> {
                    Client client1 = webSocketFrameHandler.getClient();
                    if (client.isAuth && client.username != null ? !client1.isAuth || !client.username.equals(client1.username) : client1.session != client.session) {
                        return;
                    }
                    ExitResponse.exit(this.server, webSocketFrameHandler, channel, ExitRequestEvent.ExitReason.SERVER);
                });
            }
            this.sendResult((RequestEvent)new ExitRequestEvent(ExitRequestEvent.ExitReason.CLIENT));
        } else {
            this.service.forEachActiveChannels((channel, webSocketFrameHandler) -> {
                Client client1 = webSocketFrameHandler.getClient();
                if (client1 != null && client.isAuth && client.username != null && client1.username.equals(this.username)) {
                    ExitResponse.exit(this.server, webSocketFrameHandler, channel, ExitRequestEvent.ExitReason.SERVER);
                }
            });
            this.sendResult((RequestEvent)new ExitRequestEvent(ExitRequestEvent.ExitReason.NO_EXIT));
        }
    }

    public static void exit(LaunchServer server, WebSocketFrameHandler wsHandler, Channel channel, ExitRequestEvent.ExitReason reason) {
        Client chClient = wsHandler.getClient();
        Client newCusClient = new Client(null);
        newCusClient.checkSign = chClient.checkSign;
        wsHandler.setClient(newCusClient);
        if (chClient.session != null) {
            server.sessionManager.remove(chClient.session);
        }
        ExitRequestEvent event = new ExitRequestEvent(reason);
        event.requestUUID = RequestEvent.eventUUID;
        wsHandler.service.sendObject(channel, (Object)event);
    }
}

