/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import pro.gravit.launcher.LauncherInject;
import pro.gravit.launcher.LauncherInjectionConstructor;
import pro.gravit.launchserver.asm.NodeUtils;
import pro.gravit.launchserver.binary.BuildContext;
import pro.gravit.launchserver.binary.tasks.MainBuildTask;

public class InjectClassAcceptor
implements MainBuildTask.ASMTransformer {
    private static final List<Class<?>> primitiveLDCClasses = Arrays.asList(Integer.class, Long.class, Float.class, Double.class, String.class);
    private static final String INJECTED_FIELD_DESC = Type.getDescriptor(LauncherInject.class);
    private static final String INJECTED_CONSTRUCTOR_DESC = Type.getDescriptor(LauncherInjectionConstructor.class);
    private static final List<String> primitiveLDCDescriptors = Arrays.asList(Type.INT_TYPE.getDescriptor(), Type.DOUBLE_TYPE.getDescriptor(), Type.FLOAT_TYPE.getDescriptor(), Type.LONG_TYPE.getDescriptor(), Type.getDescriptor(String.class));
    private static final Map<Class<?>, Serializer<?>> serializers = new HashMap();
    private final Map<String, Object> values;

    public InjectClassAcceptor(Map<String, Object> values) {
        this.values = values;
    }

    private static void visit(ClassNode classNode, Map<String, Object> values) {
        MethodNode clinitMethod = classNode.methods.stream().filter(methodNode -> "<clinit>".equals(methodNode.name)).findFirst().orElseGet(() -> {
            MethodNode newClinitMethod = new MethodNode(4106, "<clinit>", "()V", null, null);
            newClinitMethod.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(newClinitMethod);
            return newClinitMethod;
        });
        List constructors = classNode.methods.stream().filter(method -> "<init>".equals(method.name)).collect(Collectors.toList());
        MethodNode initMethod = constructors.stream().filter(method -> method.invisibleAnnotations != null && method.invisibleAnnotations.stream().anyMatch(annotation -> INJECTED_CONSTRUCTOR_DESC.equals(annotation.desc))).findFirst().orElseGet(() -> constructors.stream().filter(method -> method.desc.equals("()V")).findFirst().orElse(null));
        classNode.fields.forEach(field -> {
            AnnotationNode valueAnnotation;
            AnnotationNode annotationNode = valueAnnotation = field.invisibleAnnotations != null ? (AnnotationNode)field.invisibleAnnotations.stream().filter(annotation -> INJECTED_FIELD_DESC.equals(annotation.desc)).findFirst().orElse(null) : null;
            if (valueAnnotation == null) {
                return;
            }
            field.invisibleAnnotations.remove(valueAnnotation);
            AtomicReference<Object> valueName = new AtomicReference<Object>(null);
            valueAnnotation.accept(new AnnotationVisitor(458752, (FieldNode)field, valueName){
                final /* synthetic */ FieldNode val$field;
                final /* synthetic */ AtomicReference val$valueName;
                {
                    this.val$field = fieldNode;
                    this.val$valueName = atomicReference;
                    super(arg0);
                }

                public void visit(String name, Object value) {
                    if ("value".equals(name)) {
                        if (value.getClass() != String.class) {
                            throw new IllegalArgumentException(String.format("Invalid annotation with value class %s", this.val$field.getClass().getName()));
                        }
                        this.val$valueName.set(value.toString());
                    }
                }
            });
            if (valueName.get() == null) {
                throw new IllegalArgumentException("Annotation should always contains 'value' key");
            }
            if (!values.containsKey(valueName.get())) {
                return;
            }
            Object value = values.get(valueName.get());
            if ((field.access & 8) != 0) {
                if (primitiveLDCDescriptors.contains(field.desc) && primitiveLDCClasses.contains(value.getClass())) {
                    field.value = value;
                    return;
                }
                List putStaticNodes = Arrays.stream(clinitMethod.instructions.toArray()).filter(node -> node instanceof FieldInsnNode && node.getOpcode() == 179).map(p -> (FieldInsnNode)p).filter(node -> node.owner.equals(classNode.name) && node.name.equals(field.name) && node.desc.equals(field.desc)).collect(Collectors.toList());
                InsnList setter = InjectClassAcceptor.serializeValue(value);
                if (putStaticNodes.isEmpty()) {
                    setter.add((AbstractInsnNode)new FieldInsnNode(179, classNode.name, field.name, field.desc));
                    Arrays.stream(clinitMethod.instructions.toArray()).filter(node -> node.getOpcode() == 177).forEach(node -> clinitMethod.instructions.insertBefore(node, setter));
                } else {
                    setter.insert((AbstractInsnNode)new InsnNode(Type.getType((String)field.desc).getSize() == 1 ? 87 : 88));
                    for (FieldInsnNode fieldInsnNode : putStaticNodes) {
                        clinitMethod.instructions.insertBefore((AbstractInsnNode)fieldInsnNode, setter);
                    }
                }
            } else {
                if (initMethod == null) {
                    throw new IllegalArgumentException(String.format("Not found init in target: %s", classNode.name));
                }
                List putFieldNodes = Arrays.stream(initMethod.instructions.toArray()).filter(node -> node instanceof FieldInsnNode && node.getOpcode() == 181).map(p -> (FieldInsnNode)p).filter(node -> node.owner.equals(classNode.name) && node.name.equals(field.name) && node.desc.equals(field.desc)).collect(Collectors.toList());
                InsnList setter = InjectClassAcceptor.serializeValue(value);
                if (putFieldNodes.isEmpty()) {
                    setter.insert((AbstractInsnNode)new VarInsnNode(25, 0));
                    setter.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, field.name, field.desc));
                    Arrays.stream(initMethod.instructions.toArray()).filter(node -> node.getOpcode() == 177).forEach(node -> initMethod.instructions.insertBefore(node, setter));
                } else {
                    setter.insert((AbstractInsnNode)new InsnNode(Type.getType((String)field.desc).getSize() == 1 ? 87 : 88));
                    for (FieldInsnNode fieldInsnNode : putFieldNodes) {
                        initMethod.instructions.insertBefore((AbstractInsnNode)fieldInsnNode, setter);
                    }
                }
            }
        });
    }

    private static Serializer<?> serializerClass(final int opcode) {
        return new Serializer<Number>(){

            @Override
            public InsnList serialize(Number value) {
                InsnList ret = new InsnList();
                ret.add(NodeUtils.push(value.intValue()));
                ret.add((AbstractInsnNode)new InsnNode(opcode));
                return ret;
            }
        };
    }

    private static InsnList serializeValue(Object value) {
        if (value == null) {
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new InsnNode(1));
            return insnList;
        }
        if (primitiveLDCClasses.contains(value.getClass())) {
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new LdcInsnNode(value));
            return insnList;
        }
        for (Map.Entry<Class<?>, Serializer<?>> serializerEntry : serializers.entrySet()) {
            if (!serializerEntry.getKey().isInstance(value)) continue;
            return serializerEntry.getValue().serialize(value);
        }
        throw new UnsupportedOperationException(String.format("Serialization of type %s is not supported", value.getClass()));
    }

    public static boolean isSerializableValue(Object value) {
        if (value == null) {
            return true;
        }
        if (primitiveLDCClasses.contains(value.getClass())) {
            return true;
        }
        for (Map.Entry<Class<?>, Serializer<?>> serializerEntry : serializers.entrySet()) {
            if (!serializerEntry.getKey().isInstance(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void transform(ClassNode classNode, String className, BuildContext context) {
        InjectClassAcceptor.visit(classNode, this.values);
    }

    static {
        serializers.put(List.class, new ListSerializer());
        serializers.put(Map.class, new MapSerializer());
        serializers.put(byte[].class, new ByteArraySerializer());
        serializers.put(Short.class, InjectClassAcceptor.serializerClass(147));
        serializers.put(Byte.class, InjectClassAcceptor.serializerClass(145));
        serializers.put(Type.class, e -> {
            InsnList ret = new InsnList();
            ret.add((AbstractInsnNode)new LdcInsnNode(e));
            return ret;
        });
        serializers.put(Boolean.class, e -> {
            InsnList ret = new InsnList();
            ret.add((AbstractInsnNode)new InsnNode(e != false ? 4 : 3));
            return ret;
        });
        serializers.put(Character.class, e -> {
            InsnList ret = new InsnList();
            ret.add(NodeUtils.push(e.charValue()));
            ret.add((AbstractInsnNode)new InsnNode(146));
            return ret;
        });
        serializers.put(Enum.class, NodeUtils::makeValueEnumGetter);
    }

    private static class ByteArraySerializer
    implements Serializer<byte[]> {
        private ByteArraySerializer() {
        }

        @Override
        public InsnList serialize(byte[] value) {
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Base64.class), "getDecoder", Type.getMethodDescriptor((Type)Type.getType(Base64.Decoder.class), (Type[])new Type[0]), false));
            insnList.add(NodeUtils.getSafeStringInsnList(Base64.getEncoder().encodeToString(value)));
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Base64.Decoder.class), "decode", Type.getMethodDescriptor((Type)Type.getType(byte[].class), (Type[])new Type[]{Type.getType(String.class)}), false));
            return insnList;
        }
    }

    private static class MapSerializer
    implements Serializer<Map> {
        private MapSerializer() {
        }

        @Override
        public InsnList serialize(Map value) {
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new TypeInsnNode(187, Type.getInternalName(value.getClass())));
            insnList.add((AbstractInsnNode)new InsnNode(89));
            insnList.add((AbstractInsnNode)new MethodInsnNode(183, Type.getInternalName(value.getClass()), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false));
            Iterator iterator = value.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entryObject;
                Map.Entry entry = entryObject = iterator.next();
                insnList.add((AbstractInsnNode)new InsnNode(89));
                insnList.add(InjectClassAcceptor.serializeValue(entry.getKey()));
                insnList.add(InjectClassAcceptor.serializeValue(entry.getValue()));
                insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(Map.class), "put", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), true));
                insnList.add((AbstractInsnNode)new InsnNode(87));
            }
            return insnList;
        }
    }

    private static class ListSerializer
    implements Serializer<List> {
        private ListSerializer() {
        }

        @Override
        public InsnList serialize(List value) {
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new TypeInsnNode(187, Type.getInternalName(ArrayList.class)));
            insnList.add((AbstractInsnNode)new InsnNode(89));
            insnList.add(NodeUtils.push(value.size()));
            insnList.add((AbstractInsnNode)new MethodInsnNode(183, Type.getInternalName(ArrayList.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE}), false));
            for (Object object : value) {
                insnList.add((AbstractInsnNode)new InsnNode(89));
                insnList.add(InjectClassAcceptor.serializeValue(object));
                insnList.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(List.class), "add", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), true));
                insnList.add((AbstractInsnNode)new InsnNode(87));
            }
            return insnList;
        }
    }

    @FunctionalInterface
    private static interface Serializer<T> {
        public InsnList serialize(T var1);
    }
}

