/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.protect;

import java.util.HashMap;
import java.util.Map;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.GetSecureLevelInfoRequestEvent;
import pro.gravit.launcher.events.request.HardwareReportRequestEvent;
import pro.gravit.launcher.events.request.VerifySecureLevelKeyRequestEvent;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.protect.StdProtectHandler;
import pro.gravit.launchserver.auth.protect.hwid.HWIDException;
import pro.gravit.launchserver.auth.protect.hwid.HWIDProvider;
import pro.gravit.launchserver.auth.protect.interfaces.HardwareProtectHandler;
import pro.gravit.launchserver.auth.protect.interfaces.JoinServerProtectHandler;
import pro.gravit.launchserver.auth.protect.interfaces.SecureProtectHandler;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.launchserver.socket.response.secure.HardwareReportResponse;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.helper.LogHelper;

public class AdvancedProtectHandler
extends StdProtectHandler
implements SecureProtectHandler,
HardwareProtectHandler,
JoinServerProtectHandler,
Reconfigurable {
    public boolean enableHardwareFeature;
    public HWIDProvider provider;

    @Override
    public boolean allowGetAccessToken(AuthResponse.AuthContext context) {
        return context.authType == AuthResponse.ConnectTypes.CLIENT && context.client.checkSign;
    }

    @Override
    public void checkLaunchServerLicense() {
    }

    @Override
    public GetSecureLevelInfoRequestEvent onGetSecureLevelInfo(GetSecureLevelInfoRequestEvent event) {
        return event;
    }

    @Override
    public boolean allowGetSecureLevelInfo(Client client) {
        return client.checkSign;
    }

    @Override
    public void onHardwareReport(HardwareReportResponse response, Client client) {
        if (!this.enableHardwareFeature) {
            response.sendResult((RequestEvent)new HardwareReportRequestEvent());
            return;
        }
        try {
            if (!client.isAuth || client.trustLevel == null || client.trustLevel.publicKey == null) {
                response.sendError("Access denied");
                return;
            }
            this.provider.normalizeHardwareInfo(response.hardware);
            LogHelper.debug((String)"[HardwareInfo] HardwareInfo received");
            boolean needCreate = !this.provider.addPublicKeyToHardwareInfo(response.hardware, client.trustLevel.publicKey, client);
            LogHelper.debug((String)"[HardwareInfo] HardwareInfo needCreate: %s", (Object[])new Object[]{needCreate ? "true" : "false"});
            if (needCreate) {
                this.provider.createHardwareInfo(response.hardware, client.trustLevel.publicKey, client);
            }
            client.trustLevel.hardwareInfo = response.hardware;
        }
        catch (HWIDException e) {
            throw new SecurityException(e.getMessage());
        }
        response.sendResult((RequestEvent)new HardwareReportRequestEvent());
    }

    @Override
    public VerifySecureLevelKeyRequestEvent onSuccessVerify(Client client) {
        if (this.enableHardwareFeature) {
            if (this.provider == null) {
                LogHelper.warning((String)"HWIDProvider null. HardwareInfo not checked!");
            } else {
                try {
                    client.trustLevel.hardwareInfo = this.provider.findHardwareInfoByPublicKey(client.trustLevel.publicKey, client);
                    if (client.trustLevel.hardwareInfo == null) {
                        return new VerifySecureLevelKeyRequestEvent(true);
                    }
                }
                catch (HWIDException e) {
                    throw new SecurityException(e.getMessage());
                }
            }
            return new VerifySecureLevelKeyRequestEvent(false);
        }
        return new VerifySecureLevelKeyRequestEvent();
    }

    @Override
    public Map<String, Command> getCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        if (this.provider instanceof Reconfigurable) {
            commands.putAll(((Reconfigurable)((Object)this.provider)).getCommands());
        }
        return commands;
    }

    @Override
    public boolean onJoinServer(String serverID, String username, Client client) {
        return !this.enableHardwareFeature || client.trustLevel != null && client.trustLevel.hardwareInfo != null;
    }

    @Override
    public void init() {
        if (this.provider != null) {
            this.provider.init();
        }
    }

    @Override
    public void close() {
        if (this.provider != null) {
            this.provider.close();
        }
    }
}

