/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.protect.hwid;

import java.util.Arrays;
import pro.gravit.launcher.request.secure.HardwareReportRequest;
import pro.gravit.launchserver.auth.protect.hwid.HWIDException;
import pro.gravit.launchserver.auth.protect.hwid.MemoryHWIDProvider;
import pro.gravit.launchserver.auth.protect.hwid.MysqlHWIDProvider;
import pro.gravit.launchserver.helper.DamerauHelper;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public abstract class HWIDProvider {
    public static final ProviderMap<HWIDProvider> providers = new ProviderMap("HWIDProvider");
    private static boolean registredProv = false;

    public static void registerProviders() {
        if (!registredProv) {
            providers.register("memory", MemoryHWIDProvider.class);
            providers.register("mysql", MysqlHWIDProvider.class);
            registredProv = true;
        }
    }

    public abstract HardwareReportRequest.HardwareInfo findHardwareInfoByPublicKey(byte[] var1, Client var2) throws HWIDException;

    public abstract void createHardwareInfo(HardwareReportRequest.HardwareInfo var1, byte[] var2, Client var3) throws HWIDException;

    public abstract boolean addPublicKeyToHardwareInfo(HardwareReportRequest.HardwareInfo var1, byte[] var2, Client var3) throws HWIDException;

    public void normalizeHardwareInfo(HardwareReportRequest.HardwareInfo hardwareInfo) {
        if (hardwareInfo.baseboardSerialNumber != null) {
            hardwareInfo.baseboardSerialNumber = hardwareInfo.baseboardSerialNumber.trim();
        }
        if (hardwareInfo.hwDiskId != null) {
            hardwareInfo.hwDiskId = hardwareInfo.hwDiskId.trim();
        }
    }

    public HardwareInfoCompareResult compareHardwareInfo(HardwareReportRequest.HardwareInfo first, HardwareReportRequest.HardwareInfo second) {
        HardwareInfoCompareResult result = new HardwareInfoCompareResult();
        if (first.hwDiskId == null || first.hwDiskId.isEmpty()) {
            result.firstSpoofingLevel += 0.9;
        }
        if (first.displayId == null || first.displayId.length < 4) {
            result.firstSpoofingLevel += 0.3;
        }
        if (first.baseboardSerialNumber == null || first.baseboardSerialNumber.trim().isEmpty()) {
            result.firstSpoofingLevel += 0.2;
        }
        if (second.hwDiskId == null || second.hwDiskId.trim().isEmpty()) {
            result.secondSpoofingLevel += 0.9;
        }
        if (second.displayId == null || second.displayId.length < 4) {
            result.secondSpoofingLevel += 0.3;
        }
        if (second.baseboardSerialNumber == null || second.baseboardSerialNumber.trim().isEmpty()) {
            result.secondSpoofingLevel += 0.2;
        }
        if (first.hwDiskId != null && second.hwDiskId != null) {
            double addLevel;
            int hwDIskIdRate = DamerauHelper.calculateDistance(first.hwDiskId.toLowerCase(), second.hwDiskId.toLowerCase());
            if (hwDIskIdRate == 0) {
                result.compareLevel += 0.99;
            } else if (hwDIskIdRate < 3) {
                result.compareLevel += 0.85;
            } else if (hwDIskIdRate < (first.hwDiskId.length() + second.hwDiskId.length()) / 4 && (addLevel = (double)hwDIskIdRate / ((double)(first.hwDiskId.length() + second.hwDiskId.length()) / 2.0)) > 0.0 && addLevel < 0.85) {
                result.compareLevel += addLevel;
            }
        }
        if (first.baseboardSerialNumber != null && second.baseboardSerialNumber != null) {
            int baseboardSerialRate = DamerauHelper.calculateDistance(first.baseboardSerialNumber.toLowerCase(), second.baseboardSerialNumber.toLowerCase());
            if (baseboardSerialRate == 0) {
                result.compareLevel += 0.3;
            } else if (baseboardSerialRate < 3) {
                result.compareLevel += 0.15;
            }
        }
        if (first.displayId != null && second.displayId != null && Arrays.equals(first.displayId, second.displayId)) {
            result.compareLevel += 0.75;
        }
        if (first.logicalProcessors == 0 || first.physicalProcessors == 0 || first.logicalProcessors < first.physicalProcessors) {
            result.firstSpoofingLevel += 0.9;
        }
        if (second.logicalProcessors == 0 || second.physicalProcessors == 0 || second.logicalProcessors < second.physicalProcessors) {
            result.secondSpoofingLevel += 0.9;
        }
        if (first.physicalProcessors == second.physicalProcessors && first.logicalProcessors == second.logicalProcessors) {
            result.compareLevel += 0.05;
        }
        if (first.battery != second.battery) {
            result.compareLevel -= 0.05;
        }
        if (first.processorMaxFreq == second.processorMaxFreq) {
            result.compareLevel += 0.1;
        }
        if (first.totalMemory == second.totalMemory) {
            result.compareLevel += 0.1;
        }
        if (Math.abs(first.totalMemory - second.totalMemory) < 32768L) {
            result.compareLevel += 0.05;
        }
        return result;
    }

    protected void printHardwareInfo(LogHelper.Level logLevel, HardwareReportRequest.HardwareInfo info) {
        LogHelper.log((LogHelper.Level)logLevel, (String)String.format("[HardwareInfo] Processor: logical %d | physical %d | freq %d | bitness %d", info.logicalProcessors, info.physicalProcessors, info.processorMaxFreq, info.bitness), (boolean)false);
        LogHelper.log((LogHelper.Level)logLevel, (String)String.format("[HardwareInfo] Memory max: %d | battery %s", info.totalMemory, info.battery ? "true" : "false"), (boolean)false);
        LogHelper.log((LogHelper.Level)logLevel, (String)String.format("[HardwareInfo] HWDiskID %s | baseboardSerialNumber %s | displayId hash: %s", info.hwDiskId, info.baseboardSerialNumber, SecurityHelper.toHex((byte[])SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.MD5, (byte[])info.displayId))), (boolean)false);
    }

    public void init() {
    }

    public void close() {
    }

    public static class HardwareInfoCompareResult {
        public double firstSpoofingLevel = 0.0;
        public double secondSpoofingLevel = 0.0;
        public double compareLevel;
    }
}

