/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.protect.hwid;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.launcher.request.secure.HardwareReportRequest;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.auth.protect.hwid.HWIDException;
import pro.gravit.launchserver.auth.protect.hwid.HWIDProvider;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class MemoryHWIDProvider
extends HWIDProvider
implements Reconfigurable {
    public double warningSpoofingLevel = -1.0;
    public double criticalCompareLevel = 1.0;
    public Set<MemoryHWIDEntity> db = ConcurrentHashMap.newKeySet();

    @Override
    public Map<String, Command> getCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("hardwarelist", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                for (MemoryHWIDEntity e : MemoryHWIDProvider.this.db) {
                    MemoryHWIDProvider.this.printHardwareInfo(LogHelper.Level.INFO, e.hardware);
                    LogHelper.info((String)"ID %d banned %s", (Object[])new Object[]{e.id, e.banned ? "true" : "false"});
                    LogHelper.info((String)"PublicKey Hash: %s", (Object[])new Object[]{SecurityHelper.toHex((byte[])SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA1, (byte[])e.publicKey))});
                }
            }
        });
        commands.put("hardwareban", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                long id = Long.parseLong(args[0]);
                for (MemoryHWIDEntity e : MemoryHWIDProvider.this.db) {
                    if (e.id != id) continue;
                    e.banned = true;
                    LogHelper.info((String)"HardwareID %d banned", (Object[])new Object[]{e.id});
                }
            }
        });
        return commands;
    }

    @Override
    public HardwareReportRequest.HardwareInfo findHardwareInfoByPublicKey(byte[] publicKey, Client client) throws HWIDException {
        for (MemoryHWIDEntity e : this.db) {
            if (!Arrays.equals(e.publicKey, publicKey)) continue;
            if (e.banned) {
                throw new HWIDException("You HWID banned");
            }
            return e.hardware;
        }
        return null;
    }

    @Override
    public void createHardwareInfo(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] publicKey, Client client) throws HWIDException {
        this.db.add(new MemoryHWIDEntity(hardwareInfo, publicKey));
    }

    @Override
    public boolean addPublicKeyToHardwareInfo(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] publicKey, Client client) throws HWIDException {
        boolean isAlreadyWarning = false;
        for (MemoryHWIDEntity e : this.db) {
            HWIDProvider.HardwareInfoCompareResult result = this.compareHardwareInfo(e.hardware, hardwareInfo);
            if (this.warningSpoofingLevel > 0.0 && result.firstSpoofingLevel > this.warningSpoofingLevel && !isAlreadyWarning) {
                LogHelper.warning((String)"HardwareInfo spoofing level too high: %d", (Object[])new Object[]{result.firstSpoofingLevel});
                isAlreadyWarning = true;
            }
            if (!(result.compareLevel > this.criticalCompareLevel)) continue;
            LogHelper.debug((String)"HardwareInfo publicKey change: compareLevel %d", (Object[])new Object[]{result.compareLevel});
            if (e.banned) {
                throw new HWIDException("You HWID banned");
            }
            e.publicKey = publicKey;
            return true;
        }
        return false;
    }

    static class MemoryHWIDEntity {
        public HardwareReportRequest.HardwareInfo hardware;
        public byte[] publicKey;
        public boolean banned;
        public long id;

        public MemoryHWIDEntity(HardwareReportRequest.HardwareInfo hardware, byte[] publicKey) {
            this.hardware = hardware;
            this.publicKey = publicKey;
            this.id = SecurityHelper.newRandom().nextLong();
        }
    }
}

