/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.texture;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.launchserver.auth.texture.TextureProvider;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public final class RequestTextureProvider
extends TextureProvider {
    private String skinURL;
    private String cloakURL;

    public RequestTextureProvider() {
    }

    public RequestTextureProvider(String skinURL, String cloakURL) {
        this.skinURL = skinURL;
        this.cloakURL = cloakURL;
    }

    private static Texture getTexture(String url, boolean cloak) throws IOException {
        if (LogHelper.isDebugEnabled()) {
            LogHelper.debug((String)"Getting texture: '%s'", (Object[])new Object[]{url});
        }
        try {
            return new Texture(url, cloak);
        }
        catch (FileNotFoundException ignored) {
            LogHelper.subDebug((String)"Texture not found :(");
            return null;
        }
    }

    private static String getTextureURL(String url, UUID uuid, String username, String client) {
        return CommonHelper.replace((String)url, (String[])new String[]{"username", IOHelper.urlEncode((String)username), "uuid", IOHelper.urlEncode((String)uuid.toString()), "hash", IOHelper.urlEncode((String)Launcher.toHash((UUID)uuid)), "client", IOHelper.urlEncode((String)(client == null ? "unknown" : client))});
    }

    @Override
    public void close() {
    }

    @Override
    public Texture getCloakTexture(UUID uuid, String username, String client) throws IOException {
        return RequestTextureProvider.getTexture(RequestTextureProvider.getTextureURL(this.cloakURL, uuid, username, client), true);
    }

    @Override
    public Texture getSkinTexture(UUID uuid, String username, String client) throws IOException {
        return RequestTextureProvider.getTexture(RequestTextureProvider.getTextureURL(this.skinURL, uuid, username, client), false);
    }
}

