/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary.tasks;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.ParseException;
import proguard.ProGuard;

public class ProGuardBuildTask
implements LauncherBuildTask {
    private final LaunchServer server;

    public ProGuardBuildTask(LaunchServer server) {
        this.server = server;
    }

    @Override
    public String getName() {
        return "ProGuard";
    }

    @Override
    public Path process(Path inputFile) throws IOException {
        Path outputJar = this.server.launcherBinary.nextLowerPath(this);
        if (this.server.config.launcher.enabledProGuard) {
            Configuration proguard_cfg = new Configuration();
            ConfigurationParser parser = new ConfigurationParser(this.server.proguardConf.buildConfig(inputFile, outputJar), this.server.proguardConf.proguard.toFile(), System.getProperties());
            if (JVMHelper.JVM_VERSION >= 9) {
                Path javaJModsPath = Paths.get(System.getProperty("java.home"), new String[0]).resolve("jmods");
                if (!IOHelper.exists((Path)javaJModsPath)) {
                    LogHelper.warning((String)"Directory %s not found. It is not good", (Object[])new Object[]{javaJModsPath});
                } else {
                    if (!IOHelper.exists((Path)javaJModsPath.resolve("javafx.base.jmod"))) {
                        LogHelper.warning((String)"javafx.base.jmod not found. Launcher can be assembled incorrectly. Maybe you need to install OpenJFX?");
                    }
                    if (!IOHelper.exists((Path)javaJModsPath.resolve("javafx.graphics.jmod"))) {
                        LogHelper.warning((String)"javafx.graphics.jmod not found. Launcher can be assembled incorrectly. Maybe you need to install OpenJFX?");
                    }
                    if (!IOHelper.exists((Path)javaJModsPath.resolve("javafx.controls.jmod"))) {
                        LogHelper.warning((String)"javafx.controls.jmod not found. Launcher can be assembled incorrectly. Maybe you need to install OpenJFX?");
                    }
                }
            }
            try {
                parser.parse(proguard_cfg);
                ProGuard proGuard = new ProGuard(proguard_cfg);
                proGuard.execute();
            }
            catch (ParseException e) {
                LogHelper.error((Throwable)e);
            }
        } else {
            IOHelper.copy((Path)inputFile, (Path)outputJar);
        }
        return outputJar;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }
}

