/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.hash;

import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.UUID;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public final class DownloadClientCommand
extends Command {
    public DownloadClientCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[version] [dir]";
    }

    public String getUsageDescription() {
        return "Download client dir";
    }

    public void invoke(String ... args) throws IOException, CommandException {
        ClientProfile client;
        this.verifyArgs(args, 2);
        String versionName = args[0];
        String dirName = IOHelper.verifyFileName((String)args[1]);
        Path clientDir = this.server.updatesDir.resolve(args[1]);
        LogHelper.subInfo((String)"Creating client dir: '%s'", (Object[])new Object[]{dirName});
        Files.createDirectory(clientDir, new FileAttribute[0]);
        LogHelper.subInfo((String)"Downloading client, it may take some time");
        this.server.mirrorManager.downloadZip(clientDir, "clients/%s.zip", versionName);
        LogHelper.subInfo((String)"Creaing profile file: '%s'", (Object[])new Object[]{dirName});
        String profilePath = String.format("pro/gravit/launchserver/defaults/profile%s.cfg", versionName);
        try (BufferedReader reader = IOHelper.newReader((URL)IOHelper.getResourceURL((String)profilePath));){
            client = (ClientProfile)Launcher.gsonManager.configGson.fromJson((Reader)reader, ClientProfile.class);
        }
        catch (IOException e) {
            JsonElement clientJson = this.server.mirrorManager.jsonRequest(null, "GET", "clients/%s.json", versionName);
            client = (ClientProfile)Launcher.gsonManager.configGson.fromJson(clientJson, ClientProfile.class);
        }
        client.setTitle(dirName);
        client.setDir(dirName);
        client.setUUID(UUID.randomUUID());
        try (BufferedWriter writer = IOHelper.newWriter((Path)IOHelper.resolveIncremental((Path)this.server.profilesDir, (String)dirName, (String)"json"));){
            Launcher.gsonManager.configGson.toJson((Object)client, (Appendable)writer);
        }
        this.server.syncProfilesDir();
        this.server.syncUpdatesDir(Collections.singleton(dirName));
        LogHelper.subInfo((String)"Client successfully downloaded: '%s'", (Object[])new Object[]{dirName});
    }
}

