/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pro.gravit.launcher.NeedGarbageCollection;
import pro.gravit.launchserver.Reconfigurable;
import pro.gravit.launchserver.components.Component;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.LogHelper;

public abstract class AbstractLimiter<T>
extends Component
implements NeedGarbageCollection,
Reconfigurable {
    public final List<T> exclude = new ArrayList<T>();
    protected final transient Map<T, LimitEntry> map = new HashMap<T, LimitEntry>();
    public int rateLimit;
    public int rateLimitMillis;

    @Override
    public Map<String, Command> getCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put("gc", (Command)new SubCommand(){

            public void invoke(String ... args) {
                long size = AbstractLimiter.this.map.size();
                AbstractLimiter.this.garbageCollection();
                LogHelper.info((String)"Cleared %d entity", (Object[])new Object[]{size});
            }
        });
        commands.put("clear", (Command)new SubCommand(){

            public void invoke(String ... args) {
                long size = AbstractLimiter.this.map.size();
                AbstractLimiter.this.map.clear();
                LogHelper.info((String)"Cleared %d entity", (Object[])new Object[]{size});
            }
        });
        commands.put("addExclude", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                AbstractLimiter.this.exclude.add(AbstractLimiter.this.getFromString(args[0]));
            }
        });
        commands.put("rmExclude", (Command)new SubCommand(){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                AbstractLimiter.this.exclude.remove(AbstractLimiter.this.getFromString(args[0]));
            }
        });
        commands.put("clearExclude", (Command)new SubCommand(){

            public void invoke(String ... args) {
                AbstractLimiter.this.exclude.clear();
            }
        });
        return commands;
    }

    protected abstract T getFromString(String var1);

    public void garbageCollection() {
        long time = System.currentTimeMillis();
        this.map.entrySet().removeIf(e -> ((LimitEntry)e.getValue()).time + (long)this.rateLimitMillis < time);
    }

    public boolean check(T address) {
        if (this.exclude.contains(address)) {
            return true;
        }
        LimitEntry entry = this.map.get(address);
        if (entry == null) {
            this.map.put(address, new LimitEntry());
            return true;
        }
        long time = System.currentTimeMillis();
        if (entry.trys < this.rateLimit) {
            ++entry.trys;
            entry.time = time;
            return true;
        }
        if (entry.time + (long)this.rateLimitMillis < time) {
            entry.trys = 1;
            entry.time = time;
            return true;
        }
        return false;
    }

    static class LimitEntry {
        long time;
        int trys;

        public LimitEntry(long time, int trys) {
            this.time = time;
            this.trys = trys;
        }

        public LimitEntry() {
            this.time = System.currentTimeMillis();
            this.trys = 0;
        }
    }
}

