/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.handlers;

import java.net.InetSocketAddress;
import javax.net.ssl.SSLServerSocketFactory;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.socket.LauncherNettyServer;
import pro.gravit.utils.helper.LogHelper;

public final class NettyServerSocketHandler
implements Runnable,
AutoCloseable {
    private final transient LaunchServer server;
    public volatile boolean logConnections = Boolean.getBoolean("launcher.logConnections");
    public LauncherNettyServer nettyServer;
    private SSLServerSocketFactory ssf;

    public NettyServerSocketHandler(LaunchServer server) {
        this.server = server;
    }

    @Override
    public void close() {
        if (this.nettyServer == null) {
            return;
        }
        this.nettyServer.close();
        this.nettyServer.service.channels.close();
    }

    @Override
    public void run() {
        LogHelper.info((String)"Starting netty server socket thread");
        this.nettyServer = new LauncherNettyServer(this.server);
        for (LaunchServerConfig.NettyBindAddress address : this.server.config.netty.binds) {
            this.nettyServer.bind(new InetSocketAddress(address.address, address.port));
        }
    }
}

