/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.NettyConnectContext;
import pro.gravit.launchserver.socket.WebSocketService;
import pro.gravit.utils.BiHookSet;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class WebSocketFrameHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    public final LaunchServer srv;
    public final WebSocketService service;
    private final UUID connectUUID = UUID.randomUUID();
    public NettyConnectContext context;
    public BiHookSet<ChannelHandlerContext, WebSocketFrame> hooks = new BiHookSet();
    private Client client;

    public WebSocketFrameHandler(NettyConnectContext context, LaunchServer srv, WebSocketService service) {
        this.context = context;
        this.srv = srv;
        this.service = service;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public final UUID getConnectUUID() {
        return this.connectUUID;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (LogHelper.isDevEnabled()) {
            LogHelper.dev((String)"New client %s", (Object[])new Object[]{IOHelper.getIP((SocketAddress)ctx.channel().remoteAddress())});
        }
        this.client = new Client(0L);
        Channel ch = ctx.channel();
        this.service.registerClient(ch);
        ctx.executor().schedule(() -> ch.writeAndFlush((Object)new PingWebSocketFrame(), ch.voidPromise()), 30L, TimeUnit.SECONDS);
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (this.hooks.hook((Object)ctx, (Object)frame)) {
            return;
        }
        if (frame instanceof TextWebSocketFrame) {
            this.service.process(ctx, (TextWebSocketFrame)frame, this.client, this.context.ip);
        } else if (frame instanceof PingWebSocketFrame) {
            frame.content().retain();
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content()));
        } else if (frame instanceof PongWebSocketFrame) {
            LogHelper.dev((String)"WebSocket Client received pong");
        } else if (frame instanceof CloseWebSocketFrame) {
            ctx.channel().close();
        } else {
            String message = "unsupported frame type: " + frame.getClass().getName();
            LogHelper.error((Throwable)new UnsupportedOperationException(message));
        }
    }
}

