/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.ExitRequestEvent;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.handlers.WebSocketFrameHandler;
import pro.gravit.launchserver.socket.response.SimpleResponse;

public class ExitResponse
extends SimpleResponse {
    public boolean exitAll;
    public String username;

    @Override
    public String getType() {
        return "exit";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) throws Exception {
        if (!(this.username == null || client.isAuth && client.permissions != null && client.permissions.isPermission(ClientPermissions.PermissionConsts.ADMIN))) {
            this.sendError("Permissions denied");
            return;
        }
        if (this.username == null) {
            if (client.session == 0L && this.exitAll) {
                this.sendError("Session invalid");
                return;
            }
            WebSocketFrameHandler handler = (WebSocketFrameHandler)ctx.pipeline().get(WebSocketFrameHandler.class);
            if (handler == null) {
                this.sendError("Exit internal error");
                return;
            }
            Client newClient = new Client(0L);
            newClient.checkSign = client.checkSign;
            handler.setClient(newClient);
            if (client.session != 0L) {
                this.server.sessionManager.removeClient(client.session);
            }
            if (this.exitAll) {
                this.service.channels.forEach(channel -> {
                    if (channel == null || channel.pipeline() == null) {
                        return;
                    }
                    WebSocketFrameHandler wsHandler = (WebSocketFrameHandler)channel.pipeline().get(WebSocketFrameHandler.class);
                    if (wsHandler == null || wsHandler == handler) {
                        return;
                    }
                    Client chClient = wsHandler.getClient();
                    if (client.isAuth && client.username != null ? !chClient.isAuth || !client.username.equals(chClient.username) : chClient.session != client.session) {
                        return;
                    }
                    Client newCusClient = new Client(0L);
                    newCusClient.checkSign = chClient.checkSign;
                    wsHandler.setClient(newCusClient);
                    if (chClient.session != 0L) {
                        this.server.sessionManager.removeClient(chClient.session);
                    }
                    ExitRequestEvent event = new ExitRequestEvent(ExitRequestEvent.ExitReason.SERVER);
                    event.requestUUID = RequestEvent.eventUUID;
                    wsHandler.service.sendObject((Channel)channel, (Object)event);
                });
            }
            this.sendResult((RequestEvent)new ExitRequestEvent(ExitRequestEvent.ExitReason.CLIENT));
        } else {
            this.service.channels.forEach(channel -> {
                if (channel == null || channel.pipeline() == null) {
                    return;
                }
                WebSocketFrameHandler wsHandler = (WebSocketFrameHandler)channel.pipeline().get(WebSocketFrameHandler.class);
                if (wsHandler == null) {
                    return;
                }
                Client chClient = wsHandler.getClient();
                if (!chClient.isAuth || !this.username.equals(chClient.username)) {
                    return;
                }
                Client newCusClient = new Client(0L);
                newCusClient.checkSign = chClient.checkSign;
                wsHandler.setClient(newCusClient);
                if (chClient.session != 0L) {
                    this.server.sessionManager.removeClient(chClient.session);
                }
                ExitRequestEvent event = new ExitRequestEvent(ExitRequestEvent.ExitReason.SERVER);
                event.requestUUID = RequestEvent.eventUUID;
                wsHandler.service.sendObject((Channel)channel, (Object)event);
            });
            this.sendResult((RequestEvent)new ExitRequestEvent(ExitRequestEvent.ExitReason.NO_EXIT));
        }
    }
}

