/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth;

import java.io.IOException;
import java.util.Map;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.handler.AuthHandler;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.launchserver.auth.texture.TextureProvider;

public class AuthProviderPair {
    public final boolean isDefault = true;
    public AuthProvider provider;
    public AuthHandler handler;
    public TextureProvider textureProvider;
    public Map<String, String> links;
    public transient String name;
    public String displayName;

    public AuthProviderPair(AuthProvider provider, AuthHandler handler, TextureProvider textureProvider) {
        this.provider = provider;
        this.handler = handler;
        this.textureProvider = textureProvider;
    }

    public void init(LaunchServer srv, String name) {
        this.name = name;
        if (this.links != null) {
            this.link(srv);
        }
        if (this.provider == null) {
            throw new NullPointerException(String.format("Auth %s provider null", name));
        }
        if (this.handler == null) {
            throw new NullPointerException(String.format("Auth %s handler null", name));
        }
        if (this.textureProvider == null) {
            throw new NullPointerException(String.format("Auth %s textureProvider null", name));
        }
        this.provider.init(srv);
        this.handler.init(srv);
    }

    public void link(LaunchServer srv) {
        this.links.forEach((k, v) -> {
            AuthProviderPair pair = srv.config.getAuthProviderPair((String)v);
            if (pair == null) {
                throw new NullPointerException(String.format("Auth %s link failed. Pair %s not found", this.name, v));
            }
            if ("provider".equals(k)) {
                if (pair.provider == null) {
                    throw new NullPointerException(String.format("Auth %s link failed. %s.provider is null", this.name, v));
                }
                this.provider = pair.provider;
            } else if ("handler".equals(k)) {
                if (pair.handler == null) {
                    throw new NullPointerException(String.format("Auth %s link failed. %s.handler is null", this.name, v));
                }
                this.handler = pair.handler;
            } else if ("textureProvider".equals(k)) {
                if (pair.textureProvider == null) {
                    throw new NullPointerException(String.format("Auth %s link failed. %s.textureProvider is null", this.name, v));
                }
                this.textureProvider = pair.textureProvider;
            }
        });
    }

    public void close() throws IOException {
        this.provider.close();
        this.handler.close();
        this.textureProvider.close();
    }
}

