/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.handler;

import java.io.IOException;
import java.net.URL;
import java.util.UUID;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.handler.CachedAuthHandler;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public final class RequestAuthHandler
extends CachedAuthHandler {
    private final String splitSymbol = ":";
    private final String goodResponse = "OK";
    private String usernameFetch;
    private String uuidFetch;
    private String updateAuth;
    private String updateServerID;

    @Override
    public void init(LaunchServer srv) {
        super.init(srv);
        if (this.usernameFetch == null) {
            LogHelper.error((String)"[Verify][AuthHandler] usernameFetch cannot be null");
        }
        if (this.uuidFetch == null) {
            LogHelper.error((String)"[Verify][AuthHandler] uuidFetch cannot be null");
        }
        if (this.updateAuth == null) {
            LogHelper.error((String)"[Verify][AuthHandler] updateAuth cannot be null");
        }
        if (this.updateServerID == null) {
            LogHelper.error((String)"[Verify][AuthHandler] updateServerID cannot be null");
        }
    }

    @Override
    protected CachedAuthHandler.Entry fetchEntry(UUID uuid) throws IOException {
        String response = IOHelper.request((URL)new URL(CommonHelper.replace((String)this.uuidFetch, (String[])new String[]{"uuid", IOHelper.urlEncode((String)uuid.toString())})));
        String[] parts = response.split(":");
        String username = parts[0];
        String accessToken = parts[1];
        String serverID = parts[2];
        if (LogHelper.isDebugEnabled()) {
            LogHelper.debug((String)("[AuthHandler] Got username: " + username));
            LogHelper.debug((String)("[AuthHandler] Got accessToken: " + accessToken));
            LogHelper.debug((String)("[AuthHandler] Got serverID: " + serverID));
            LogHelper.debug((String)("[AuthHandler] Got UUID: " + uuid));
        }
        return new CachedAuthHandler.Entry(uuid, username, accessToken, serverID);
    }

    @Override
    protected CachedAuthHandler.Entry fetchEntry(String username) throws IOException {
        String response = IOHelper.request((URL)new URL(CommonHelper.replace((String)this.usernameFetch, (String[])new String[]{"user", IOHelper.urlEncode((String)username)})));
        String[] parts = response.split(":");
        UUID uuid = UUID.fromString(parts[0]);
        String accessToken = parts[1];
        String serverID = parts[2];
        if (LogHelper.isDebugEnabled()) {
            LogHelper.debug((String)("[AuthHandler] Got username: " + username));
            LogHelper.debug((String)("[AuthHandler] Got accessToken: " + accessToken));
            LogHelper.debug((String)("[AuthHandler] Got serverID: " + serverID));
            LogHelper.debug((String)("[AuthHandler] Got UUID: " + uuid));
        }
        return new CachedAuthHandler.Entry(uuid, username, accessToken, serverID);
    }

    @Override
    protected boolean updateAuth(UUID uuid, String username, String accessToken) throws IOException {
        String response = IOHelper.request((URL)new URL(CommonHelper.replace((String)this.updateAuth, (String[])new String[]{"user", IOHelper.urlEncode((String)username), "uuid", IOHelper.urlEncode((String)uuid.toString()), "token", IOHelper.urlEncode((String)accessToken)})));
        if (LogHelper.isDebugEnabled()) {
            LogHelper.debug((String)("[AuthHandler] Set accessToken: " + accessToken));
            LogHelper.debug((String)("[AuthHandler] Set UUID: " + uuid));
            LogHelper.debug((String)("[AuthHandler] For this username: " + username));
        }
        return "OK".equals(response);
    }

    @Override
    protected boolean updateServerID(UUID uuid, String serverID) throws IOException {
        String response = IOHelper.request((URL)new URL(CommonHelper.replace((String)this.updateAuth, (String[])new String[]{"serverid", IOHelper.urlEncode((String)serverID), "uuid", IOHelper.urlEncode((String)uuid.toString())})));
        if (LogHelper.isDebugEnabled()) {
            LogHelper.debug((String)("[AuthHandler] Set serverID: " + serverID));
            LogHelper.debug((String)("[AuthHandler] For this UUID: " + uuid));
        }
        return "OK".equals(response);
    }

    @Override
    public void close() {
    }
}

