/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.provider;

import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.provider.AuthProvider;
import pro.gravit.utils.helper.SecurityHelper;

public abstract class DigestAuthProvider
extends AuthProvider {
    private SecurityHelper.DigestAlgorithm digest;

    protected final void verifyDigest(String validDigest, String password) throws AuthException {
        boolean valid;
        if (this.digest == SecurityHelper.DigestAlgorithm.PLAIN) {
            valid = password.equals(validDigest);
        } else if (validDigest == null) {
            valid = false;
        } else {
            byte[] actualDigest = SecurityHelper.digest((SecurityHelper.DigestAlgorithm)this.digest, (String)password);
            valid = SecurityHelper.toHex((byte[])actualDigest).equals(validDigest);
        }
        if (!valid) {
            DigestAuthProvider.authError("Incorrect username or password");
        }
    }
}

