/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.dump;

import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import pro.gravit.launcher.Launcher;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.utils.command.SubCommand;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class DumpSessionsCommand
extends Command {
    public DumpSessionsCommand(final LaunchServer server) {
        super(server);
        this.childCommands.put("load", new SubCommand(){

            public void invoke(String ... args) throws Exception {
                int size;
                this.verifyArgs(args, 1);
                LogHelper.info((String)"Sessions read from %s", (Object[])new Object[]{args[0]});
                try (BufferedReader reader = IOHelper.newReader((Path)Paths.get(args[0], new String[0]));){
                    Type setType = new TypeToken<HashSet<Client>>(){}.getType();
                    Set clientSet = (Set)Launcher.gsonManager.configGson.fromJson((Reader)reader, setType);
                    size = clientSet.size();
                    server.sessionManager.loadSessions(clientSet);
                }
                LogHelper.subInfo((String)"Readed %d sessions", (Object[])new Object[]{size});
            }
        });
        this.childCommands.put("unload", new SubCommand(){

            public void invoke(String ... args) throws Exception {
                this.verifyArgs(args, 1);
                LogHelper.info((String)"Sessions write to %s", (Object[])new Object[]{args[0]});
                Set<Client> clientSet = server.sessionManager.getSessions();
                try (BufferedWriter writer = IOHelper.newWriter((Path)Paths.get(args[0], new String[0]));){
                    Launcher.gsonManager.configGson.toJson(clientSet, (Appendable)writer);
                }
                LogHelper.subInfo((String)"Write %d sessions", (Object[])new Object[]{clientSet.size()});
            }
        });
    }

    public String getArgsDescription() {
        return "[load/unload] [filename]";
    }

    public String getUsageDescription() {
        return "Load or unload sessions";
    }

    public void invoke(String ... args) throws Exception {
        this.invokeSubcommands(args);
    }
}

