/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.service;

import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.handler.CachedAuthHandler;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.command.CommandHandler;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class ServerStatusCommand
extends Command {
    public ServerStatusCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return null;
    }

    public String getUsageDescription() {
        return "Check server status";
    }

    public void invoke(String ... args) {
        LogHelper.info((String)"Show server status");
        LogHelper.info((String)"Memory: free %d | total: %d | max: %d", (Object[])new Object[]{JVMHelper.RUNTIME.freeMemory(), JVMHelper.RUNTIME.totalMemory(), JVMHelper.RUNTIME.maxMemory()});
        long uptime = JVMHelper.RUNTIME_MXBEAN.getUptime() / 1000L;
        long second = uptime % 60L;
        long min = uptime / 60L % 60L;
        long hour = uptime / 60L / 60L % 24L;
        long days = uptime / 60L / 60L / 24L;
        LogHelper.info((String)"Uptime: %d days %d hours %d minutes %d seconds", (Object[])new Object[]{days, hour, min, second});
        LogHelper.info((String)"Uptime (double): %f", (Object[])new Object[]{(double)JVMHelper.RUNTIME_MXBEAN.getUptime() / 1000.0});
        int commands = this.server.commandHandler.getBaseCategory().commandsMap().size();
        for (CommandHandler.Category category : this.server.commandHandler.getCategories()) {
            commands += category.category.commandsMap().size();
        }
        LogHelper.info((String)"Sessions: %d | Commands: %d(%d categories)", (Object[])new Object[]{this.server.sessionManager.getSessions().size(), commands, this.server.commandHandler.getCategories().size() + 1});
        for (AuthProviderPair pair : this.server.config.auth.values()) {
            if (!(pair.handler instanceof CachedAuthHandler)) continue;
            LogHelper.info((String)"AuthHandler %s: EntryCache: %d | usernameCache: %d", (Object[])new Object[]{pair.name, ((CachedAuthHandler)pair.handler).getEntryCache().size(), ((CachedAuthHandler)pair.handler).getUsernamesCache().size()});
        }
    }
}

