/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.service;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.tasks.SignJarTask;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.helper.LogHelper;

public class SignJarCommand
extends Command {
    public SignJarCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[path to file] (path to signed file)";
    }

    public String getUsageDescription() {
        return "sign custom jar";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        Path target = Paths.get(args[0], new String[0]);
        Path tmpSign = args.length > 1 ? Paths.get(args[1], new String[0]) : this.server.dir.resolve("build").resolve(target.toFile().getName());
        LogHelper.info((String)"Signing jar %s to %s", (Object[])new Object[]{target.toString(), tmpSign.toString()});
        Optional<SignJarTask> task = this.server.launcherBinary.getTaskByClass(SignJarTask.class);
        if (!task.isPresent()) {
            throw new IllegalStateException("SignJarTask not found");
        }
        task.get().sign(this.server.config.sign, target, tmpSign);
        if (args.length <= 1) {
            LogHelper.info((String)"Move temp jar %s to %s", (Object[])new Object[]{tmpSign.toString(), target.toString()});
            Files.deleteIfExists(target);
            Files.move(tmpSign, target, new CopyOption[0]);
        }
        LogHelper.info((String)"Success signed");
    }
}

