/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.manangers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import pro.gravit.launcher.NeedGarbageCollection;
import pro.gravit.launchserver.socket.Client;

public class SessionManager
implements NeedGarbageCollection {
    public static final long SESSION_TIMEOUT = 10800000L;
    private final Map<UUID, Client> clientSet = new HashMap<UUID, Client>(128);

    public boolean addClient(Client client) {
        this.clientSet.put(client.session, client);
        return true;
    }

    public void garbageCollection() {
        long time = System.currentTimeMillis();
        this.clientSet.entrySet().removeIf(entry -> {
            Client c = (Client)entry.getValue();
            return c.timestamp + 10800000L < time;
        });
    }

    public Client getClient(UUID session) {
        return this.clientSet.get(session);
    }

    public Client getOrNewClient(UUID session) {
        return this.clientSet.computeIfAbsent(session, Client::new);
    }

    public Client removeClient(UUID session) {
        return this.clientSet.remove(session);
    }

    public void updateClient(UUID session) {
        Client c = this.clientSet.get(session);
        if (c != null) {
            c.up();
            return;
        }
        Client newClient = new Client(session);
        this.clientSet.put(session, newClient);
    }

    public Set<Client> getSessions() {
        return new HashSet<Client>(this.clientSet.values());
    }

    public void loadSessions(Set<Client> set) {
        this.clientSet.putAll(set.stream().collect(Collectors.toMap(c -> c.session, Function.identity())));
    }
}

