/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.handlers;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.ReferenceCounted;
import java.util.List;
import pro.gravit.launchserver.socket.NettyConnectContext;
import pro.gravit.utils.helper.LogHelper;

public class NettyIpForwardHandler
extends MessageToMessageDecoder<HttpRequest> {
    private final NettyConnectContext context;

    public NettyIpForwardHandler(NettyConnectContext context) {
        this.context = context;
    }

    protected void decode(ChannelHandlerContext ctx, HttpRequest msg, List<Object> out) {
        if (msg instanceof ReferenceCounted) {
            ((ReferenceCounted)msg).retain();
        }
        if (this.context.ip != null) {
            out.add(msg);
            return;
        }
        HttpHeaders headers = msg.headers();
        String realIP = null;
        if (headers.contains("X-Forwarded-For")) {
            realIP = headers.get("X-Forwarded-For");
        }
        if (headers.contains("X-Real-IP")) {
            realIP = headers.get("X-Real-IP");
        }
        if (realIP != null) {
            if (LogHelper.isDevEnabled()) {
                LogHelper.dev((String)"Real IP address %s", (Object[])new Object[]{realIP});
            }
            this.context.ip = realIP;
        } else {
            LogHelper.error((String)"IpForwarding error. Headers not found");
        }
        out.add(msg);
    }
}

